/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptUtils {
    private static final Logger log = LoggerFactory.getLogger((String)ScriptUtils.class.getName());
    private static final Pattern BYTECODE_SIZE_MESSAGE = Pattern.compile(".*generated bytecode .+ exceeds 64K limit.*");
    private static final int MAX_COMPILED_SCRIPT_LENGTH = 131072;

    public static Script tryCompile(Context cx, String code, String fileName) {
        if (code.length() > 131072) {
            return null;
        }
        try {
            return cx.compileString(code, fileName, 1, null);
        }
        catch (EvaluatorException ee) {
            if (BYTECODE_SIZE_MESSAGE.matcher(ee.getMessage()).matches()) {
                if (log.isDebugEnabled()) {
                    log.debug("Source code for {} is too large -- running later in interpreted mode", (Object)fileName);
                }
                return null;
            }
            throw ee;
        }
        catch (IllegalArgumentException ie) {
            if (log.isDebugEnabled()) {
                log.debug("Source code for {} failed compilation, possibly too large", (Object)fileName);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object interpretScript(Context cx, Scriptable scope, String code, String fileName) {
        if (log.isDebugEnabled()) {
            log.debug("Executing script from {} in interpreted mode because it was too large", (Object)fileName);
        }
        int oldOpt = cx.getOptimizationLevel();
        try {
            cx.setOptimizationLevel(-1);
            Object object = cx.evaluateString(scope, code, fileName, 1, null);
            return object;
        }
        finally {
            cx.setOptimizationLevel(oldOpt);
        }
    }
}

