/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeEnvironment;
import io.apigee.trireme.core.NodeException;
import io.apigee.trireme.core.NodeModule;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.NodeScript;
import io.apigee.trireme.core.Sandbox;
import io.apigee.trireme.core.ScriptFuture;
import io.apigee.trireme.core.ScriptStatus;
import io.apigee.trireme.core.ScriptTask;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractModuleRegistry;
import io.apigee.trireme.core.internal.AbstractProcess;
import io.apigee.trireme.core.internal.JavaVersion;
import io.apigee.trireme.core.internal.NodeExitException;
import io.apigee.trireme.core.internal.TriremeProcess;
import io.apigee.trireme.core.modules.AbstractFilesystem;
import io.apigee.trireme.core.modules.Buffer;
import io.apigee.trireme.core.modules.NativeModule;
import io.apigee.trireme.kernel.PathTranslator;
import io.apigee.trireme.kernel.fs.AdvancedFilesystem;
import io.apigee.trireme.kernel.fs.BasicFilesystem;
import io.apigee.trireme.kernel.net.NetworkPolicy;
import io.apigee.trireme.kernel.net.SelectorHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner
implements NodeRuntime,
Callable<ScriptStatus> {
    public static final String RUNNER = "runner";
    private static final Logger log = LoggerFactory.getLogger(ScriptRunner.class);
    private static final long DEFAULT_DELAY = Integer.MAX_VALUE;
    public static final String TIMEOUT_TIMESTAMP_KEY = "_tickTimeout";
    private final NodeEnvironment env;
    private long now;
    private AbstractModuleRegistry registry;
    private File scriptFile;
    private String script;
    private final NodeScript scriptObject;
    private final String[] args;
    private final HashMap<String, NativeModule.ModuleImpl> moduleCache = new HashMap();
    private final HashMap<String, Object> internalModuleCache = new HashMap();
    private ScriptFuture future;
    private final CountDownLatch initialized = new CountDownLatch(1);
    private final Sandbox sandbox;
    private final PathTranslator pathTranslator;
    private final ExecutorService asyncPool;
    private final IdentityHashMap<Closeable, Closeable> openHandles = new IdentityHashMap();
    private final ConcurrentLinkedQueue<Activity> tickFunctions = new ConcurrentLinkedQueue();
    private final PriorityQueue<Activity> timerQueue = new PriorityQueue();
    private final Selector selector;
    private int timerSequence;
    private final AtomicInteger pinCount = new AtomicInteger(0);
    private BasicFilesystem filesystem;
    private NativeModule.NativeImpl nativeModule;
    protected AbstractProcess process;
    private String workingDirectory;
    private String scriptFileName;
    private TriremeProcess parentProcess;
    private boolean forceRepl;
    private ScriptableObject scope;

    public ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, File scriptFile, String[] args) {
        this(so, env, sandbox, args);
        this.scriptFile = scriptFile;
        try {
            this.scriptFileName = this.pathTranslator.reverseTranslate(scriptFile.getPath());
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)("Error translating file path: " + ioe));
        }
    }

    public ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, String scriptName, String script, String[] args) {
        this(so, env, sandbox, args);
        this.script = script;
        this.scriptFileName = scriptName;
    }

    public ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, String[] args, boolean forceRepl) {
        this(so, env, sandbox, args);
        this.forceRepl = forceRepl;
    }

    private ScriptRunner(NodeScript so, NodeEnvironment env, Sandbox sandbox, String[] args) {
        this.env = env;
        this.scriptObject = so;
        this.args = args;
        this.sandbox = sandbox;
        this.pathTranslator = new PathTranslator();
        if (sandbox != null && sandbox.getFilesystemRoot() != null) {
            try {
                this.pathTranslator.setRoot(sandbox.getFilesystemRoot());
            }
            catch (IOException ioe) {
                throw new AssertionError((Object)("Unexpected I/O error setting filesystem root: " + ioe));
            }
        }
        this.workingDirectory = sandbox != null && sandbox.getWorkingDirectory() != null ? sandbox.getWorkingDirectory() : (sandbox != null && sandbox.getFilesystemRoot() != null ? "/" : new File(".").getAbsolutePath());
        this.pathTranslator.setWorkingDir(this.workingDirectory);
        this.asyncPool = sandbox != null && sandbox.getAsyncThreadPool() != null ? sandbox.getAsyncThreadPool() : env.getAsyncPool();
        if (sandbox != null && sandbox.getMounts() != null) {
            for (Map.Entry<String, String> mount : sandbox.getMounts()) {
                this.pathTranslator.mount(mount.getKey(), new File(mount.getValue()));
            }
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            throw new AssertionError((Object)ioe);
        }
    }

    public void close() {
        try {
            this.selector.close();
        }
        catch (IOException ioe) {
            log.debug("Error closing selector", (Throwable)ioe);
        }
    }

    public void setFuture(ScriptFuture future) {
        this.future = future;
    }

    public ScriptFuture getFuture() {
        return this.future;
    }

    @Override
    public NodeEnvironment getEnvironment() {
        return this.env;
    }

    public long getLoopTimestamp() {
        return this.now;
    }

    public AbstractModuleRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(AbstractModuleRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Sandbox getSandbox() {
        return this.sandbox;
    }

    public NetworkPolicy getNetworkPolicy() {
        return this.sandbox == null ? null : this.sandbox.getNetworkPolicy();
    }

    @Override
    public NodeScript getScriptObject() {
        return this.scriptObject;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(String wd) throws IOException {
        File wdf = new File(wd);
        if (wdf.isAbsolute()) {
            this.workingDirectory = wd;
        } else {
            File newWdf = new File(this.workingDirectory, wd);
            this.workingDirectory = newWdf.getCanonicalPath();
        }
        this.pathTranslator.setWorkingDir(this.workingDirectory);
    }

    public Scriptable getScriptScope() {
        return this.scope;
    }

    public NativeModule.NativeImpl getNativeModule() {
        return this.nativeModule;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public ExecutorService getAsyncPool() {
        return this.asyncPool;
    }

    public ExecutorService getUnboundedPool() {
        return this.env.getScriptPool();
    }

    public BasicFilesystem getFilesystem() {
        return this.filesystem;
    }

    public InputStream getStdin() {
        return this.sandbox != null && this.sandbox.getStdin() != null ? this.sandbox.getStdin() : System.in;
    }

    public OutputStream getStdout() {
        return this.sandbox != null && this.sandbox.getStdout() != null ? this.sandbox.getStdout() : System.out;
    }

    public OutputStream getStderr() {
        return this.sandbox != null && this.sandbox.getStderr() != null ? this.sandbox.getStderr() : System.err;
    }

    public TriremeProcess getParentProcess() {
        return this.parentProcess;
    }

    public AbstractProcess getProcess() {
        return this.process;
    }

    public void setParentProcess(TriremeProcess parentProcess) {
        this.parentProcess = parentProcess;
    }

    public void awaitInitialization() {
        try {
            this.initialized.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public File translatePath(String path) {
        if (path.startsWith("\\\\?\\")) {
            path = path.substring(4);
        }
        File pf = new File(path);
        return this.pathTranslator.translate(pf.getPath());
    }

    @Override
    public String reverseTranslatePath(String path) throws IOException {
        return this.pathTranslator.reverseTranslate(path);
    }

    public PathTranslator getPathTranslator() {
        return this.pathTranslator;
    }

    @Override
    public void enqueueCallback(Function f, Scriptable scope, Scriptable thisObj, Object[] args) {
        this.enqueueCallback(f, scope, thisObj, null, args);
    }

    @Override
    public void enqueueCallback(Function f, Scriptable scope, Scriptable thisObj, Object domain, Object[] args) {
        Callback cb = new Callback(f, scope, thisObj, args);
        cb.setDomain((Scriptable)domain);
        this.tickFunctions.offer(cb);
        this.selector.wakeup();
    }

    @Override
    public void enqueueTask(ScriptTask task) {
        this.enqueueTask(task, null);
    }

    @Override
    public void enqueueTask(ScriptTask task, Object domain) {
        Task t = new Task(task, (Scriptable)this.scope);
        t.setDomain((Scriptable)domain);
        this.tickFunctions.offer(t);
        this.selector.wakeup();
    }

    public void executeScriptTask(Runnable r, Object domain) {
        RunnableTask t = new RunnableTask(r);
        t.setDomain((Scriptable)domain);
        this.tickFunctions.offer(t);
        this.selector.wakeup();
    }

    public void executeCallback(Context cx, Object[] args, Function function, Scriptable thisObj) {
        this.process.submitTick(cx, args, function, thisObj, this.process.getDomain());
    }

    public void enqueueIpc(Context cx, Object message, final TriremeProcess child) {
        Object toDeliver;
        String event = "message";
        if (message == TriremeProcess.IPC_DISCONNECT) {
            event = "disconnect";
            toDeliver = Undefined.instance;
        } else if (message instanceof Buffer.BufferImpl) {
            ByteBuffer bb = ((Buffer.BufferImpl)((Object)message)).getBuffer();
            toDeliver = Buffer.BufferImpl.newBuffer(cx, (Scriptable)this.scope, bb, true);
        } else if (message instanceof Scriptable) {
            String cmd;
            Scriptable s = (Scriptable)message;
            toDeliver = this.copy(cx, s);
            if (s.has("cmd", s) && (cmd = Context.toString((Object)s.get("cmd", s))).startsWith("NODE_")) {
                event = "internalMessage";
            }
        } else if (message instanceof String) {
            toDeliver = message;
        } else {
            throw new AssertionError((Object)"Unsupported object type for IPC");
        }
        final Object reallyDeliver = toDeliver;
        final String fevent = event;
        if (child == null) {
            this.enqueueTask(new ScriptTask(){

                @Override
                public void execute(Context cx, Scriptable scope) {
                    ScriptRunner.this.process.emitEvent(fevent, reallyDeliver, cx, scope);
                }
            });
        } else {
            assert (child.getRuntime() != this);
            child.getRuntime().enqueueTask(new ScriptTask(){

                @Override
                public void execute(Context cx, Scriptable scope) {
                    child.getOnMessage().call(cx, scope, null, new Object[]{fevent, reallyDeliver});
                }
            });
        }
    }

    private Scriptable copy(Context cx, Scriptable s) {
        if (s instanceof Function) {
            return null;
        }
        Scriptable t = cx.newObject((Scriptable)this.scope);
        for (Object id : s.getIds()) {
            Object val;
            if (id instanceof String) {
                String n = (String)id;
                val = s.get(n, s);
                if (val instanceof Scriptable) {
                    val = this.copy(cx, (Scriptable)val);
                }
                t.put(n, t, val);
                continue;
            }
            if (id instanceof Number) {
                int i = ((Number)id).intValue();
                val = s.get(i, s);
                if (val instanceof Scriptable) {
                    val = this.copy(cx, (Scriptable)val);
                }
                t.put(i, t, val);
                continue;
            }
            throw new AssertionError();
        }
        return t;
    }

    public Object getDomain() {
        return ArgUtils.ensureValid(this.process.getDomain());
    }

    public Activity createTimer(long delay, boolean repeating, long repeatInterval, ScriptTask task, Scriptable scope) {
        Task t = new Task(task, scope);
        long timeout = System.currentTimeMillis() + delay;
        int seq = this.timerSequence++;
        if (log.isDebugEnabled()) {
            log.debug("Going to fire timeout {} at {}", (Object)seq, (Object)timeout);
        }
        t.setId(seq);
        t.setTimeout(timeout);
        if (repeating) {
            t.setInterval(repeatInterval);
            t.setRepeating(true);
        }
        this.timerQueue.add(t);
        this.selector.wakeup();
        return t;
    }

    public Future<Boolean> createTimedTask(Runnable r, long delay, TimeUnit unit, boolean repeating, Object domain) {
        final RunnableTask t = new RunnableTask(r);
        t.setDomain((Scriptable)domain);
        t.setTimeout(System.currentTimeMillis() + unit.toMillis(delay));
        t.setRepeating(repeating);
        if (repeating) {
            t.setInterval(delay);
        }
        this.enqueueTask(new ScriptTask(){

            @Override
            public void execute(Context cx, Scriptable scope) {
                if (!t.isCancelled()) {
                    t.setId(ScriptRunner.this.timerSequence++);
                    ScriptRunner.this.timerQueue.add(t);
                    ScriptRunner.this.selector.wakeup();
                }
            }
        });
        return t;
    }

    public void pin() {
        int currentPinCount = this.pinCount.incrementAndGet();
        log.debug("Pin count is now {}", (Object)currentPinCount);
    }

    public void unPin() {
        int currentPinCount = this.pinCount.decrementAndGet();
        log.debug("Pin count is now {}", (Object)currentPinCount);
        if (currentPinCount < 0) {
            log.warn("Negative pin count: {}", (Object)currentPinCount);
        }
        if (currentPinCount == 0) {
            this.selector.wakeup();
        }
    }

    public void setErrno(String err) {
        this.scope.put("errno", (Scriptable)this.scope, (Object)err);
    }

    public void clearErrno() {
        this.scope.put("errno", (Scriptable)this.scope, (Object)0);
    }

    public Object getErrno() {
        if (this.scope.has("errno", (Scriptable)this.scope)) {
            Object errno = this.scope.get("errno", (Scriptable)this.scope);
            if (errno == null) {
                return Context.getUndefinedValue();
            }
            return this.scope.get("errno", (Scriptable)this.scope);
        }
        return Context.getUndefinedValue();
    }

    public void registerCloseable(Closeable c) {
        this.openHandles.put(c, c);
    }

    public void unregisterCloseable(Closeable c) {
        this.openHandles.remove(c);
    }

    private void closeCloseables(Context cx) {
        AbstractFilesystem fs = (AbstractFilesystem)this.requireInternal("fs", cx);
        if (fs == null) {
            return;
        }
        fs.cleanup();
        for (Closeable c : this.openHandles.values()) {
            if (log.isDebugEnabled()) {
                log.debug("Closing leaked handle {}", (Object)c);
            }
            try {
                c.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Error closing leaked handle: {}", (Throwable)ioe);
            }
        }
    }

    @Override
    public ScriptStatus call() throws NodeException {
        Object ret = this.env.getContextFactory().call(new ContextAction(){

            public Object run(Context cx) {
                return ScriptRunner.this.runScript(cx);
            }
        });
        return (ScriptStatus)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ScriptStatus runScript(Context cx) {
        ScriptStatus status;
        if (this.scriptObject.getDisplayName() != null) {
            try {
                Thread.currentThread().setName("Trireme: " + this.scriptObject.getDisplayName());
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        cx.putThreadLocal((Object)RUNNER, (Object)this);
        this.now = System.currentTimeMillis();
        try {
            this.scope = cx.initStandardObjects();
            this.registry.loadRoot(cx);
            try {
                this.initGlobals(cx);
            }
            catch (NodeException ne) {
                ScriptStatus scriptStatus = new ScriptStatus(ne);
                return scriptStatus;
            }
            finally {
                this.initialized.countDown();
            }
            if (this.scriptFile == null && this.script == null) {
                this.process.setForceRepl(this.forceRepl);
                this.setRawArgv();
            } else if (this.scriptFile == null) {
                this.process.setEval(this.script);
                this.process.setPrintEval(this.scriptObject.isPrintEval());
                this.setScriptFileArgv(this.scriptFileName);
            } else {
                this.setScriptFileArgv(this.scriptFileName);
            }
            Script mainScript = this.registry.getMainScript();
            Function main = (Function)mainScript.exec(cx, (Scriptable)this.scope);
            boolean timing = this.startTiming(cx);
            try {
                main.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, new Object[]{this.process});
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
            }
            finally {
                if (timing) {
                    this.endTiming(cx);
                }
            }
            status = this.mainLoop(cx);
        }
        catch (NodeExitException ne) {
            status = ne.getStatus();
        }
        catch (IOException ioe) {
            log.debug("I/O exception processing script: {}", (Throwable)ioe);
            status = new ScriptStatus(ioe);
        }
        catch (Throwable t) {
            log.debug("Unexpected script error: {}", t);
            status = new ScriptStatus(t);
        }
        log.debug("Script exiting with exit code {}", (Object)status.getExitCode());
        if (!status.hasCause() && !this.process.isExiting()) {
            try {
                this.process.setExiting(true);
                this.process.emitEvent("exit", status.getExitCode(), cx, (Scriptable)this.process);
            }
            catch (NodeExitException ee) {
                log.debug("Script replacing exit code with {}", (Object)ee.getCode());
                status = ee.getStatus();
            }
            catch (RhinoException re) {
                status = new ScriptStatus(re);
            }
        }
        this.closeCloseables(cx);
        try {
            OutputStream stderr;
            OutputStream stdout = this.getStdout();
            if (stdout != System.out) {
                stdout.close();
            }
            if ((stderr = this.getStderr()) == System.err) return status;
            stderr.close();
            return status;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return status;
    }

    private void setRawArgv() throws NodeException {
        ArrayList<String> argv = new ArrayList<String>(this.args == null ? 2 : this.args.length + 2);
        ArrayList<String> vmArgs = new ArrayList<String>(0);
        argv.add("./node");
        if (this.args != null) {
            boolean vmArgsDone = false;
            for (String arg : this.args) {
                if (vmArgsDone) {
                    argv.add(arg);
                    continue;
                }
                if (arg.startsWith("--")) {
                    vmArgs.add(arg);
                    continue;
                }
                argv.add(arg);
                vmArgsDone = true;
            }
        }
        String[] ret = argv.toArray(new String[argv.size()]);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < ret.length; ++i) {
                log.debug("argv[{}] = {}", (Object)i, (Object)ret[i]);
            }
        }
        this.process.setArgv(ret);
        this.process.setExecArgv(vmArgs);
        this.initVmArgs();
    }

    private void setScriptFileArgv(String scriptName) throws NodeException {
        String[] finalArgs = new String[this.args == null ? 2 : this.args.length + 2];
        finalArgs[0] = "./node";
        finalArgs[1] = scriptName;
        if (this.args != null) {
            System.arraycopy(this.args, 0, finalArgs, 2, this.args.length);
        }
        if (log.isDebugEnabled()) {
            for (int i = 0; i < finalArgs.length; ++i) {
                log.debug("argv[{}] = {}", (Object)i, (Object)finalArgs[i]);
            }
        }
        this.process.setArgv(finalArgs);
        List<String> empty = Collections.emptyList();
        this.process.setExecArgv(empty);
        this.initVmArgs();
    }

    private ScriptStatus mainLoop(Context cx) throws IOException {
        while (!this.tickFunctions.isEmpty() || this.pinCount.get() > 0 || this.process.isTickTaskPending() || this.process.isImmediateTaskPending()) {
            try {
                long pollTimeout;
                if (this.future != null && this.future.isCancelled()) {
                    return ScriptStatus.CANCELLED;
                }
                this.executeNextTicks(cx);
                this.executeTicks(cx);
                this.executeImmediateCallbacks(cx);
                this.now = System.currentTimeMillis();
                if (!this.tickFunctions.isEmpty() || this.process.isTickTaskPending() || this.process.isImmediateTaskPending() || this.pinCount.get() == 0) {
                    pollTimeout = 0L;
                } else if (this.timerQueue.isEmpty()) {
                    pollTimeout = Integer.MAX_VALUE;
                } else {
                    Activity nextActivity = this.timerQueue.peek();
                    pollTimeout = nextActivity.timeout - this.now;
                }
                if (pollTimeout > 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("mainLoop: sleeping for {} pinCount = {}", (Object)pollTimeout, (Object)this.pinCount.get());
                    }
                    this.selector.select(pollTimeout);
                } else {
                    this.selector.selectNow();
                }
                this.executeNetworkCallbacks(cx);
                this.executeTimerTasks(cx, this.now);
            }
            catch (NodeExitException ne) {
                return ne.getStatus();
            }
            catch (RhinoException re) {
                return new ScriptStatus(re);
            }
        }
        return ScriptStatus.OK;
    }

    private Scriptable makeError(Context cx, RhinoException re) {
        if (re instanceof JavaScriptException && ((JavaScriptException)re).getValue() instanceof Scriptable) {
            return (Scriptable)((JavaScriptException)re).getValue();
        }
        if (re instanceof EcmaError) {
            return Utils.makeErrorObject(cx, (Scriptable)this.scope, ((EcmaError)re).getErrorMessage(), re);
        }
        return Utils.makeErrorObject(cx, (Scriptable)this.scope, re.getMessage(), re);
    }

    private boolean handleScriptException(Context cx, RhinoException re) {
        if (re instanceof NodeExitException) {
            return false;
        }
        this.endTiming(cx);
        Function handleFatal = this.process.getHandleFatal();
        if (handleFatal == null) {
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Handling fatal exception {} domain = {}\n{}", new Object[]{re, System.identityHashCode(this.process.getDomain()), re.getScriptStackTrace()});
            log.debug("Fatal Java exception: {}", (Throwable)re);
        }
        Scriptable error = this.makeError(cx, re);
        boolean handled = Context.toBoolean((Object)handleFatal.call(cx, (Scriptable)this.scope, (Scriptable)this.scope, new Object[]{error}));
        if (log.isDebugEnabled()) {
            log.debug("Handled = {}", (Object)handled);
        }
        return handled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeTicks(Context cx) throws RhinoException {
        Activity nextCall;
        do {
            if ((nextCall = this.tickFunctions.poll()) == null) continue;
            boolean timing = this.startTiming(cx);
            try {
                nextCall.execute(cx);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
                return;
            }
            finally {
                if (timing) {
                    this.endTiming(cx);
                }
            }
        } while (nextCall != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNextTicks(Context cx) throws RhinoException {
        if (this.process.isTickTaskPending()) {
            if (log.isTraceEnabled()) {
                log.trace("Executing ticks");
            }
            boolean timed = this.startTiming(cx);
            try {
                this.process.processTickTasks(cx);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
            }
            finally {
                if (timed) {
                    this.endTiming(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeImmediateCallbacks(Context cx) throws RhinoException {
        if (this.process.isImmediateTaskPending()) {
            if (log.isTraceEnabled()) {
                log.trace("Executing immediate tasks");
            }
            boolean timed = this.startTiming(cx);
            try {
                this.process.processImmediateTasks(cx);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (!handled) {
                    throw re;
                }
            }
            finally {
                if (timed) {
                    this.endTiming(cx);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNetworkCallbacks(Context cx) throws RhinoException {
        Iterator<SelectionKey> keys = this.selector.selectedKeys().iterator();
        while (keys.hasNext()) {
            SelectionKey selKey = keys.next();
            keys.remove();
            boolean timed = this.startTiming(cx);
            try {
                ((SelectorHandler)selKey.attachment()).selected(selKey);
            }
            catch (RhinoException re) {
                boolean handled = this.handleScriptException(cx, re);
                if (handled) continue;
                throw re;
            }
            finally {
                if (!timed) continue;
                this.endTiming(cx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTimerTasks(Context cx, long now) throws RhinoException {
        Activity timed = this.timerQueue.peek();
        while (timed != null && timed.timeout <= now) {
            this.timerQueue.poll();
            if (!timed.cancelled) {
                boolean timing = this.startTiming(cx);
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("Executing timer {}", (Object)timed.id);
                    }
                    timed.execute(cx);
                }
                catch (RhinoException re) {
                    boolean handled = this.handleScriptException(cx, re);
                    if (!handled) {
                        throw re;
                    }
                }
                finally {
                    if (timing) {
                        this.endTiming(cx);
                    }
                }
                if (timed.repeating && !timed.cancelled) {
                    timed.timeout = now + timed.interval;
                    if (log.isDebugEnabled()) {
                        log.debug("Re-registering {} to fire at {}", (Object)timed.id, (Object)timed.timeout);
                    }
                    this.timerQueue.add(timed);
                }
            }
            timed = this.timerQueue.peek();
        }
    }

    private void initGlobals(Context cx) throws NodeException {
        this.filesystem = JavaVersion.get().hasAsyncFileIO() ? new AdvancedFilesystem() : new BasicFilesystem();
        try {
            NativeModule.NativeImpl nativeMod;
            this.nativeModule = nativeMod = (NativeModule.NativeImpl)((Object)this.initializeModule("native_module", AbstractModuleRegistry.ModuleType.PUBLIC, cx, (Scriptable)this.scope));
            NativeModule.ModuleImpl nativeModMod = NativeModule.ModuleImpl.newModule(cx, (Scriptable)this.scope, "native_module", "native_module");
            nativeModMod.setLoaded(true);
            nativeModMod.setExports((Scriptable)nativeMod);
            this.cacheModule("native_module", nativeModMod);
            this.process = (AbstractProcess)((Object)this.require("process", cx));
            this.process.setConnected(this.parentProcess != null);
            this.scope.put("process", (Scriptable)this.scope, (Object)this.process);
        }
        catch (InvocationTargetException e) {
            throw new NodeException(e);
        }
        catch (IllegalAccessException e) {
            throw new NodeException(e);
        }
        catch (InstantiationException e) {
            throw new NodeException(e);
        }
    }

    private void initVmArgs() throws NodeException {
        for (Object arg : this.process.getExecArgv()) {
            String sa = (String)arg;
            if ("--expose-gc".equals(arg) || "--expose_gc".equals(arg)) {
                Method gc = Utils.findMethod(AbstractProcess.class, "JsGc");
                FunctionObject gcFunc = new FunctionObject("gc", (Member)gc, (Scriptable)this.scope);
                this.scope.put("gc", (Scriptable)this.scope, (Object)gcFunc);
                continue;
            }
            if ("--throw-deprecation".equals(arg)) {
                this.process.put("throwDeprecation", (Scriptable)this.process, true);
                continue;
            }
            if ("--trace-deprecation".equals(arg)) {
                this.process.put("traceDeprecation", (Scriptable)this.process, true);
                continue;
            }
            if ("--no-deprecation".equals(arg)) {
                this.process.put("throwDeprecation", (Scriptable)this.process, false);
                this.process.put("traceDeprecation", (Scriptable)this.process, false);
                continue;
            }
            if (sa.startsWith("--http-adapter") || sa.startsWith("--node-version") || sa.startsWith("--node_version") || "--debug".equals(arg) || "--trace".equals(arg)) continue;
            throw new NodeException("Unsupported command-line option " + arg);
        }
    }

    public Object initializeModule(String modName, AbstractModuleRegistry.ModuleType type, Context cx, Scriptable scope) throws InvocationTargetException, InstantiationException, IllegalAccessException {
        NodeModule mod;
        switch (type) {
            case PUBLIC: {
                mod = this.registry.get(modName);
                break;
            }
            case INTERNAL: {
                mod = this.registry.getInternal(modName);
                break;
            }
            case NATIVE: {
                mod = this.registry.getNative(modName);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (mod == null) {
            return null;
        }
        Scriptable exp = mod.registerExports(cx, scope, this);
        if (exp == null) {
            throw new AssertionError((Object)("Module " + modName + " returned a null export"));
        }
        return exp;
    }

    @Override
    public Object require(String modName, Context cx) {
        try {
            return this.nativeModule.internalRequire(modName, cx);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new EvaluatorException("Error initializing module: " + (targetException != null ? e.toString() + ": " + targetException.toString() : e.toString()));
        }
        catch (InstantiationException e) {
            throw new EvaluatorException("Error initializing module: " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new EvaluatorException("Error initializing modugle: " + e.toString());
        }
    }

    public Object requireInternal(String modName, Context cx) {
        if (this.process == null) {
            return null;
        }
        return this.process.getInternalModule(modName, cx);
    }

    public boolean isNativeModule(String name) {
        return this.registry.get(name) != null || this.registry.getCompiledModule(name) != null;
    }

    public NativeModule.ModuleImpl getCachedModule(String name) {
        return this.moduleCache.get(name);
    }

    public void cacheModule(String name, NativeModule.ModuleImpl module) {
        this.moduleCache.put(name, module);
    }

    public Object getCachedInternalModule(String name) {
        return this.internalModuleCache.get(name);
    }

    public void cacheInternalModule(String name, Object module) {
        this.internalModuleCache.put(name, module);
    }

    private boolean startTiming(Context cx) {
        long tl;
        if (this.env != null && (tl = this.env.getScriptTimeLimit()) > 0L) {
            cx.putThreadLocal((Object)TIMEOUT_TIMESTAMP_KEY, (Object)(System.currentTimeMillis() + tl));
            return true;
        }
        return false;
    }

    private void endTiming(Context cx) {
        cx.removeThreadLocal((Object)TIMEOUT_TIMESTAMP_KEY);
    }

    private final class RunnableTask
    extends AbstractTask
    implements Future<Boolean> {
        private Runnable task;

        RunnableTask(Runnable task) {
            super((Scriptable)ScriptRunner.this.scope);
            this.task = task;
        }

        @Override
        protected void executeTask(Context cx) {
            this.task.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.setCancelled(true);
            return true;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public Boolean get() {
            return Boolean.TRUE;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return Boolean.TRUE;
        }
    }

    private final class Task
    extends AbstractTask {
        private ScriptTask task;

        Task(ScriptTask task, Scriptable scope) {
            super(scope);
            this.task = task;
        }

        @Override
        protected void executeTask(Context cx) {
            this.task.execute(cx, (Scriptable)ScriptRunner.this.scope);
        }
    }

    private abstract class AbstractTask
    extends Activity {
        private Scriptable scope;

        protected AbstractTask(Scriptable scope) {
            this.scope = scope;
        }

        protected abstract void executeTask(Context var1);

        @Override
        void execute(Context cx) {
            if (this.domain != null && ScriptableObject.hasProperty((Scriptable)this.domain, (String)"_disposed")) {
                this.domain = null;
            }
            if (this.domain != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Entering domain {}", (Object)System.identityHashCode(this.domain));
                }
                Function enter = (Function)ScriptableObject.getProperty((Scriptable)this.domain, (String)"enter");
                enter.call(cx, (Scriptable)enter, this.domain, ScriptRuntime.emptyArgs);
            }
            this.executeTask(cx);
            if (this.domain != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Exiting domain {}", (Object)System.identityHashCode(this.domain));
                }
                Function exit = (Function)ScriptableObject.getProperty((Scriptable)this.domain, (String)"exit");
                exit.call(cx, (Scriptable)exit, this.domain, ScriptRuntime.emptyArgs);
            }
        }
    }

    private final class Callback
    extends Activity {
        Function function;
        Scriptable scope;
        Scriptable thisObj;
        Object[] args;

        Callback(Function f, Scriptable s, Scriptable thisObj, Object[] args) {
            this.function = f;
            this.scope = s;
            this.thisObj = thisObj;
            this.args = args;
        }

        @Override
        void execute(Context cx) {
            ScriptRunner.this.process.submitTick(cx, this.args, this.function, this.thisObj, this.domain);
        }
    }

    public abstract class Activity
    implements Comparable<Activity> {
        protected int id;
        protected long timeout;
        protected long interval;
        protected boolean repeating;
        protected boolean cancelled;
        protected Scriptable domain;

        abstract void execute(Context var1);

        int getId() {
            return this.id;
        }

        void setId(int id) {
            this.id = id;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public void setTimeout(long timeout) {
            this.timeout = timeout;
        }

        public long getInterval() {
            return this.interval;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public boolean isRepeating() {
            return this.repeating;
        }

        public void setRepeating(boolean repeating) {
            this.repeating = repeating;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void setCancelled(boolean cancelled) {
            this.cancelled = cancelled;
        }

        public Scriptable getDomain() {
            return this.domain;
        }

        public void setDomain(Scriptable domain) {
            this.domain = domain;
        }

        @Override
        public int compareTo(Activity a) {
            if (this.timeout < a.timeout) {
                return -1;
            }
            if (this.timeout > a.timeout) {
                return 1;
            }
            return 0;
        }
    }
}

