/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.GenericProcess;
import io.apigee.trireme.kernel.OSException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessManager {
    private static final Logger log = LoggerFactory.getLogger(ProcessManager.class);
    private static final ProcessManager myself = new ProcessManager();
    private final ConcurrentHashMap<Integer, GenericProcess> processTable = new ConcurrentHashMap();
    private final AtomicInteger nextPid = new AtomicInteger(1);

    private ProcessManager() {
    }

    public static ProcessManager get() {
        return myself;
    }

    public int getNextPid() {
        return this.nextPid.getAndIncrement();
    }

    public GenericProcess getProcess(int pid) {
        return this.processTable.get(pid);
    }

    public void addProcess(int pid, GenericProcess proc) {
        this.processTable.put(pid, proc);
    }

    public void removeProcess(int pid) {
        this.processTable.remove(pid);
    }

    public void kill(Context cx, Scriptable scope, int pid, String signal) {
        GenericProcess proc = this.processTable.get(pid);
        if (proc == null) {
            throw Utils.makeError(cx, scope, new OSException(-3));
        }
        if (signal != null) {
            if (log.isDebugEnabled()) {
                log.debug("Terminating pid {} ({}) with {}", new Object[]{pid, proc, signal});
            }
            proc.terminate(signal);
        }
    }
}

