/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class ProcessEnvironment
extends ScriptableObject {
    public static final String CLASS_NAME = "_Environment";
    private final HashMap<String, Object> env = new HashMap();
    private final HashMap<String, Object> aliases = new HashMap();

    public String getClassName() {
        return CLASS_NAME;
    }

    public Object[] getIds() {
        return this.env.keySet().toArray();
    }

    public Object get(String name, Scriptable scope) {
        Object ret = this.env.get(name);
        if (ret == null) {
            ret = this.aliases.get(name.toUpperCase());
        }
        return ret == null ? Scriptable.NOT_FOUND : ret;
    }

    public boolean has(String name, Scriptable scope) {
        return this.env.containsKey(name) || this.aliases.containsKey(name.toUpperCase());
    }

    public void put(String name, Scriptable scope, Object value) {
        this.env.put(name, value);
        String uc = name.toUpperCase();
        if (!uc.equals(name)) {
            this.aliases.put(uc, value);
        }
    }

    public void delete(String name) {
        this.env.remove(name);
        String uc = name.toUpperCase();
        if (!uc.equals(name)) {
            this.aliases.remove(uc);
        }
    }

    public void initialize(Map<String, String> e) {
        for (Map.Entry<String, String> entry : e.entrySet()) {
            this.put(entry.getKey(), null, entry.getValue());
        }
    }
}

