/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.ScriptStatus;
import org.mozilla.javascript.EvaluatorException;

public class NodeExitException
extends EvaluatorException {
    private final Reason reason;
    private final int code;

    public NodeExitException(Reason reason) {
        super("Script exit: " + NodeExitException.reasonToText(reason));
        this.reason = reason;
        switch (reason) {
            case NORMAL: {
                this.code = 0;
                break;
            }
            case FATAL: {
                this.code = -1;
                break;
            }
            case TIMEOUT: {
                this.code = -3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public NodeExitException(Reason reason, int code) {
        super("Script exit: " + NodeExitException.reasonToText(reason));
        this.reason = reason;
        this.code = code;
    }

    public Reason getReason() {
        return this.reason;
    }

    public int getCode() {
        return this.code;
    }

    public ScriptStatus getStatus() {
        return new ScriptStatus(this.code);
    }

    public static String reasonToText(Reason r) {
        switch (r) {
            case NORMAL: {
                return "Normal";
            }
            case FATAL: {
                return "Fatal";
            }
            case TIMEOUT: {
                return "Timeout";
            }
        }
        throw new AssertionError();
    }

    public static enum Reason {
        NORMAL,
        FATAL,
        TIMEOUT;

    }
}

