/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

public class JavaVersion {
    private static final JavaVersion myself = new JavaVersion();
    private boolean hasAsyncFileIO = this.hasClass("java.nio.channels.AsynchronousFileChannel");
    private boolean hasFlushFlags = this.hasMethod("java.util.zip.Deflater", "deflate", new Class[]{byte[].class, Integer.TYPE, Integer.TYPE, Integer.TYPE});

    private JavaVersion() {
    }

    public static JavaVersion get() {
        return myself;
    }

    public boolean hasAsyncFileIO() {
        return this.hasAsyncFileIO;
    }

    public boolean hasFlushFlags() {
        return this.hasFlushFlags;
    }

    private boolean hasClass(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException ce) {
            return false;
        }
    }

    private boolean hasMethod(String className, String methodName, Class<?>[] types) {
        try {
            Class<?> klass = Class.forName(className);
            klass.getMethod(methodName, types);
            return true;
        }
        catch (ClassNotFoundException ce) {
            return false;
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
    }
}

