/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.util.HashMap;

public class IdPropertyMap {
    final HashMap<String, Integer> propertyNames = new HashMap();
    final HashMap<Integer, String> propertyIds = new HashMap();
    final HashMap<String, MethodInfo> methodNames = new HashMap();
    final HashMap<Integer, MethodInfo> methodIds = new HashMap();
    int maxInstanceId;
    int maxPrototypeId;
    final String className;

    public IdPropertyMap(String className) {
        this.className = className;
    }

    public void addProperty(String name, int id, int attrs) {
        assert (id > 0);
        assert (!this.propertyNames.containsKey(name));
        this.propertyNames.put(name, attrs << 16 | id);
        assert (!this.propertyIds.containsKey(id));
        this.propertyIds.put(id, name);
        if (id > this.maxInstanceId) {
            this.maxInstanceId = id;
        }
    }

    public void addMethod(String name, int id, int arity) {
        assert (id > 1);
        MethodInfo mi = new MethodInfo(name, id, arity);
        assert (!this.methodNames.containsKey(name));
        this.methodNames.put(name, mi);
        assert (!this.methodIds.containsKey(id));
        this.methodIds.put(id, mi);
        if (id > this.maxPrototypeId) {
            this.maxPrototypeId = id;
        }
    }

    static final class MethodInfo {
        String name;
        int id;
        int arity;

        MethodInfo(String name, int id, int arity) {
            this.name = name;
            this.id = id;
            this.arity = arity;
        }
    }
}

