/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateParser {
    private static final Logger log = LoggerFactory.getLogger((String)CertificateParser.class.getName());
    private static final String X509_DATE_FORMAT = "MMM d HH:mm:ss yyyy zzz";
    private static final Pattern CERT_ENTRY = Pattern.compile("^(.+)=(.*)$");
    private static final Pattern ESCAPED_COMMA = Pattern.compile("\\\\,");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final CertificateParser myself = new CertificateParser();

    public static CertificateParser get() {
        return myself;
    }

    private CertificateParser() {
    }

    public Scriptable parse(Context cx, Scriptable scope, X509Certificate cert) {
        if (log.isDebugEnabled()) {
            log.debug("Returning subject " + cert.getSubjectX500Principal());
        }
        Scriptable ret = cx.newObject(scope);
        ret.put("subject", ret, (Object)this.makePrincipal(cx, scope, cert.getSubjectX500Principal()));
        ret.put("issuer", ret, (Object)this.makePrincipal(cx, scope, cert.getIssuerX500Principal()));
        ret.put("valid_from", ret, (Object)this.formatDate(cert.getNotBefore()));
        ret.put("valid_to", ret, (Object)this.formatDate(cert.getNotAfter()));
        try {
            this.addAltNames(ret, "subjectaltname", cert.getSubjectAlternativeNames());
            this.addAltNames(ret, "issueraltname", cert.getIssuerAlternativeNames());
            this.addExtendedUsage(cx, scope, ret, cert.getExtendedKeyUsage());
        }
        catch (CertificateParsingException e) {
            log.debug("Error getting all the cert names: {}", (Throwable)e);
        }
        return ret;
    }

    public Scriptable parseWithStrings(Context cx, Scriptable scope, X509Certificate cert) {
        if (log.isDebugEnabled()) {
            log.debug("Returning subject " + cert.getSubjectX500Principal());
        }
        Scriptable ret = cx.newObject(scope);
        ret.put("subject", ret, (Object)this.makeStringPrincipal(cert.getSubjectX500Principal()));
        ret.put("issuer", ret, (Object)this.makeStringPrincipal(cert.getIssuerX500Principal()));
        ret.put("valid_from", ret, (Object)this.formatDate(cert.getNotBefore()));
        ret.put("valid_to", ret, (Object)this.formatDate(cert.getNotAfter()));
        try {
            this.addAltNames(ret, "subjectaltname", cert.getSubjectAlternativeNames());
            this.addAltNames(ret, "issueraltname", cert.getIssuerAlternativeNames());
            this.addExtendedUsage(cx, scope, ret, cert.getExtendedKeyUsage());
        }
        catch (CertificateParsingException e) {
            log.debug("Error getting all the cert names: {}", (Throwable)e);
        }
        return ret;
    }

    private Scriptable makePrincipal(Context cx, Scriptable scope, X500Principal principal) {
        int cp;
        Scriptable p = cx.newObject(scope);
        String name = principal.getName("RFC2253");
        int start = 0;
        boolean wasSlash = false;
        for (cp = 0; cp < name.length(); ++cp) {
            if (name.charAt(cp) == '\\') {
                wasSlash = true;
                continue;
            }
            if (name.charAt(cp) == ',' && !wasSlash) {
                wasSlash = false;
                this.addCertEntry(p, this.unescapeCommas(name.substring(start, cp)));
                start = cp + 1;
                continue;
            }
            wasSlash = false;
        }
        if (cp > start) {
            this.addCertEntry(p, this.unescapeCommas(name.substring(start)));
        }
        return p;
    }

    private String makeStringPrincipal(X500Principal principal) {
        int cp;
        StringBuilder sb = new StringBuilder();
        String name = principal.getName("RFC2253");
        int start = 0;
        boolean wasSlash = false;
        for (cp = 0; cp < name.length(); ++cp) {
            if (name.charAt(cp) == '\\') {
                wasSlash = true;
                continue;
            }
            if (name.charAt(cp) == ',' && !wasSlash) {
                wasSlash = false;
                sb.append(this.unescapeCommas(name.substring(start, cp)));
                sb.append('\n');
                start = cp + 1;
                continue;
            }
            wasSlash = false;
        }
        if (cp > start) {
            sb.append(this.unescapeCommas(name.substring(start)));
            sb.append('\n');
        }
        return sb.toString();
    }

    private String unescapeCommas(String s) {
        return ESCAPED_COMMA.matcher(s).replaceAll(",");
    }

    private void addCertEntry(Scriptable s, String entry) {
        Matcher m = CERT_ENTRY.matcher(entry);
        if (m.matches()) {
            s.put(m.group(1), s, (Object)m.group(2));
        }
    }

    private void addAltNames(Scriptable s, String propName, Collection<List<?>> altNames) {
        if (altNames == null) {
            return;
        }
        StringBuilder names = new StringBuilder();
        boolean once = false;
        for (List<?> an : altNames) {
            if (an.size() < 2 || !(an.get(0) instanceof Integer) || !(an.get(1) instanceof String)) continue;
            int typeNum = (Integer)an.get(0);
            String typeName = "";
            switch (typeNum) {
                case 1: {
                    typeName = "IP";
                    break;
                }
                case 2: {
                    typeName = "DNS";
                    break;
                }
                case 6: {
                    typeName = "URI";
                    break;
                }
                default: {
                    return;
                }
            }
            if (once) {
                names.append(", ");
            } else {
                once = true;
            }
            names.append(typeName).append(':').append(an.get(1));
        }
        s.put(propName, s, (Object)names.toString());
    }

    private void addExtendedUsage(Context cx, Scriptable scope, Scriptable s, List<String> oids) {
        if (oids == null) {
            return;
        }
        Object[] objs = oids.toArray(new Object[oids.size()]);
        s.put("ext_key_usage", s, (Object)cx.newArray(scope, objs));
    }

    private String formatDate(Date d) {
        SimpleDateFormat format = new SimpleDateFormat(X509_DATE_FORMAT);
        format.setTimeZone(GMT);
        return format.format(d.getTime());
    }
}

