/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.ArgUtils;
import io.apigee.trireme.core.NodeRuntime;
import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.AbstractIdObject;
import io.apigee.trireme.core.internal.IdPropertyMap;
import io.apigee.trireme.core.internal.ProcessEnvironment;
import io.apigee.trireme.core.internal.ProcessManager;
import io.apigee.trireme.core.internal.ScriptRunner;
import io.apigee.trireme.core.internal.Version;
import io.apigee.trireme.kernel.Platform;
import java.io.IOException;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractProcess
extends AbstractIdObject<AbstractProcess> {
    public static final String EXECUTABLE_NAME = "./node";
    public static final int DEFAULT_UMASK = 18;
    private static final long NANO = 1000000000L;
    protected ScriptRunner runner;
    protected boolean forceRepl;
    protected boolean printEval;
    protected boolean exiting;
    protected boolean connected;
    protected String eval;
    protected Scriptable env;
    protected long startTime = System.currentTimeMillis();
    protected int umask = 18;
    protected Object[] execArgv;

    protected AbstractProcess(IdPropertyMap props) {
        super(props);
    }

    public void setRunner(NodeRuntime runner) {
        this.runner = (ScriptRunner)runner;
    }

    public abstract Object getDomain();

    public abstract void setDomain(Object var1);

    public void setEnv(ProcessEnvironment env) {
        this.env = env;
    }

    public abstract void submitTick(Context var1, Object[] var2, Function var3, Scriptable var4, Object var5);

    public abstract void emitEvent(String var1, Object var2, Context var3, Scriptable var4);

    public abstract Function getHandleFatal();

    public abstract boolean isImmediateTaskPending();

    public abstract void processImmediateTasks(Context var1);

    public abstract boolean isTickTaskPending();

    public abstract void processTickTasks(Context var1);

    public abstract Object getInternalModule(String var1, Context var2);

    public abstract void setArgv(String[] var1);

    protected Object umask(Object[] args) {
        if (args.length > 0) {
            int newMask;
            int oldMask = this.umask;
            this.umask = newMask = ArgUtils.octalOrHexIntArg(args, 0);
            return Context.toNumber((Object)oldMask);
        }
        return Context.toNumber((Object)this.umask);
    }

    public int getUmask() {
        return this.umask;
    }

    protected String getVersion() {
        return "v" + this.runner.getRegistry().getImplementation().getVersion();
    }

    protected Object getVersions() {
        Scriptable env = Context.getCurrentContext().newObject((Scriptable)this);
        env.put("trireme", env, (Object)Version.TRIREME_VERSION);
        env.put("node", env, (Object)this.runner.getRegistry().getImplementation().getVersion());
        if (Version.SSL_VERSION != null) {
            env.put("ssl", env, (Object)Version.SSL_VERSION);
            env.put("openssl", env, (Object)Version.SSL_VERSION);
        }
        env.put("java", env, (Object)System.getProperty("java.version"));
        return env;
    }

    protected Scriptable getConfig() {
        Scriptable c = Context.getCurrentContext().newObject((Scriptable)this);
        Scriptable vars = Context.getCurrentContext().newObject((Scriptable)this);
        c.put("variables", c, (Object)vars);
        return c;
    }

    protected String getArch() {
        String arch = System.getProperty("os.arch");
        if (arch.equals("x86")) {
            return "ia32";
        }
        if (arch.equals("x86_64")) {
            return "x64";
        }
        return arch;
    }

    protected void doKill(Context cx, Object[] args) {
        int pid = ArgUtils.intArg(args, 0);
        String signal = ArgUtils.stringArg(args, 1, "TERM");
        if ("0".equals(signal)) {
            signal = null;
        }
        ProcessManager.get().kill(cx, (Scriptable)this, pid, signal);
    }

    protected void chdir(Context cx, Object[] args) {
        String cd = ArgUtils.stringArg(args, 0);
        try {
            this.runner.setWorkingDirectory(cd);
        }
        catch (IOException ioe) {
            throw Utils.makeError(cx, (Scriptable)this, ioe.toString());
        }
    }

    protected String cwd() {
        return this.runner.getWorkingDirectory();
    }

    public void setExecArgv(List<String> args) {
        this.execArgv = new Object[args.size()];
        args.toArray(this.execArgv);
    }

    public Object[] getExecArgv() {
        return this.execArgv;
    }

    protected Object getJSExecArgv() {
        return Context.getCurrentContext().newArray((Scriptable)this, this.execArgv);
    }

    protected Object getFeatures(Context cx) {
        Scriptable features = cx.newObject((Scriptable)this);
        return features;
    }

    protected Object uptime() {
        long up = (System.currentTimeMillis() - this.startTime) / 1000L;
        return Context.toNumber((Object)up);
    }

    protected static Object hrtime(Context cx, Object[] args, Scriptable thisObj) {
        long nanos = System.nanoTime();
        if (args.length == 1) {
            Scriptable arg = AbstractProcess.ensureScriptable((Object)args[0]);
            if (!arg.has(0, arg) || !arg.has(1, arg)) {
                throw new EvaluatorException("Argument must be an array");
            }
            long startSecs = (long)Context.toNumber((Object)arg.get(0, arg));
            long startNs = (long)Context.toNumber((Object)arg.get(1, arg));
            long startNanos = startSecs * 1000000000L + startNs;
            nanos -= startNanos;
        } else if (args.length > 1) {
            throw new EvaluatorException("Invalid arguments");
        }
        Object[] ret = new Object[]{(int)(nanos / 1000000000L), (int)(nanos % 1000000000L)};
        return cx.newArray(thisObj, ret);
    }

    protected static Object memoryUsage(Context cx, Scriptable thisObj) {
        Runtime r = Runtime.getRuntime();
        Scriptable mem = cx.newObject(thisObj);
        long used = r.totalMemory() - r.freeMemory();
        mem.put("rss", mem, (Object)r.totalMemory());
        mem.put("heapTotal", mem, (Object)r.totalMemory());
        mem.put("heapUsed", mem, (Object)used);
        mem.put("heapMax", mem, (Object)r.maxMemory());
        return mem;
    }

    protected String getPlatform() {
        if (this.runner.getSandbox() != null && this.runner.getSandbox().isHideOSDetails()) {
            return "java";
        }
        return Platform.get().getPlatform();
    }

    protected int getPid() {
        return System.identityHashCode(this.runner) % 65536;
    }

    protected static ScriptRunner getRunner(Context cx) {
        return (ScriptRunner)cx.getThreadLocal((Object)"runner");
    }

    public void setForceRepl(boolean forceRepl) {
        this.forceRepl = forceRepl;
    }

    public void setEval(String eval) {
        this.eval = eval;
    }

    public void setPrintEval(boolean printEval) {
        this.printEval = printEval;
    }

    public void setExiting(boolean exiting) {
        this.exiting = exiting;
    }

    public boolean isExiting() {
        return this.exiting;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public static void JsGc() {
        System.gc();
    }
}

