/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core.internal;

import io.apigee.trireme.core.Utils;
import io.apigee.trireme.core.internal.IdPropertyMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.Scriptable;

public abstract class AbstractIdObject<T extends AbstractIdObject>
extends IdScriptableObject {
    protected static final int Id_constructor = 1;
    private final IdPropertyMap map;

    protected Object prototypeCall(int id, Context cx, Scriptable scope, Object[] args) {
        return this.anonymousCall(id, cx, scope, (Object)this, args);
    }

    protected Object anonymousCall(int id, Context cx, Scriptable scope, Object thisObj, Object[] args) {
        throw Utils.makeTypeError(cx, scope, "Invalid method " + id);
    }

    protected T defaultConstructor(Context cx, Object[] args) {
        return this.defaultConstructor();
    }

    protected abstract T defaultConstructor();

    protected AbstractIdObject(IdPropertyMap map) {
        this.map = map;
    }

    public String getClassName() {
        return this.map.className;
    }

    public Function exportAsClass(Scriptable scope) {
        return this.exportAsJSClass(Math.max(1, this.map.maxPrototypeId), scope, false);
    }

    protected String getInstanceIdName(int id) {
        String n = this.map.propertyIds.get(id);
        if (n == null) {
            return super.getInstanceIdName(id);
        }
        return n;
    }

    protected int findInstanceIdInfo(String name) {
        Integer info = this.map.propertyNames.get(name);
        if (info == null) {
            return super.findInstanceIdInfo(name);
        }
        return info;
    }

    protected int getMaxInstanceId() {
        return this.map.maxInstanceId;
    }

    protected void initPrototypeId(int id) {
        if (id == 1) {
            this.initPrototypeMethod(this.getClassName(), 1, "constructor", 0);
        } else {
            IdPropertyMap.MethodInfo m = this.map.methodIds.get(id);
            if (m == null) {
                throw new IllegalArgumentException(String.valueOf(id));
            }
            this.initPrototypeMethod(this.getClassName(), id, m.name, m.arity);
        }
    }

    protected int findPrototypeId(String name) {
        if ("constructor".equals(name)) {
            return 1;
        }
        IdPropertyMap.MethodInfo m = this.map.methodNames.get(name);
        if (m == null) {
            return 0;
        }
        return m.id;
    }

    public Object execIdCall(IdFunctionObject f, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (!f.hasTag((Object)this.getClassName())) {
            return super.execIdCall(f, cx, scope, thisObj, args);
        }
        if (f.methodId() == 1) {
            if (thisObj == null) {
                return this.defaultConstructor(cx, args);
            }
            return f.construct(cx, scope, args);
        }
        if (thisObj instanceof AbstractIdObject) {
            AbstractIdObject self = (AbstractIdObject)thisObj;
            return self.prototypeCall(f.methodId(), cx, scope, args);
        }
        return this.anonymousCall(f.methodId(), cx, scope, thisObj, args);
    }
}

