/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.internal.NodeOSException;
import io.apigee.trireme.kernel.Charsets;
import io.apigee.trireme.kernel.ErrorCodes;
import io.apigee.trireme.kernel.OSException;
import io.apigee.trireme.kernel.util.BufferUtils;
import io.apigee.trireme.kernel.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;

public class Utils {
    public static String readStream(InputStream in) throws IOException {
        int r;
        InputStreamReader rdr = new InputStreamReader(in, Charsets.UTF8);
        StringBuilder str = new StringBuilder();
        char[] buf = new char[4096];
        do {
            if ((r = rdr.read(buf)) <= 0) continue;
            str.append(buf, 0, r);
        } while (r > 0);
        return str.toString();
    }

    public static String readFile(File f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            String string = Utils.readStream(in);
            return string;
        }
    }

    public static Method findMethod(Class<?> klass, String name) {
        for (Method m : klass.getMethods()) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    public static String bufferToString(ByteBuffer buf, Charset cs) {
        return StringUtils.bufferToString((ByteBuffer)buf, (Charset)cs);
    }

    public static String bufferToString(ByteBuffer[] bufs, Charset cs) {
        return StringUtils.bufferToString((ByteBuffer[])bufs, (Charset)cs);
    }

    public static ByteBuffer stringToBuffer(String str, Charset cs) {
        return StringUtils.stringToBuffer((String)str, (Charset)cs);
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message) {
        return cx.newObject(scope, "Error", new Object[]{message});
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, RhinoException re) {
        Scriptable e = cx.newObject(scope, "Error", new Object[]{message});
        e.put("stack", e, (Object)re.getScriptStackTrace());
        return e;
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message));
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message, RhinoException re) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message, re));
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, String code) {
        return Utils.makeErrorObject(cx, scope, message, code, null);
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, String code, String path) {
        Scriptable err = cx.newObject(scope, "Error", new Object[]{message});
        err.put("code", err, (Object)code);
        int errno = ErrorCodes.get().toInt(code);
        if (errno != 0) {
            err.put("errno", err, (Object)errno);
        }
        if (path != null) {
            err.put("path", err, (Object)path);
        }
        return err;
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, int code, String path) {
        return Utils.makeErrorObject(cx, scope, message, ErrorCodes.get().toString(code), path);
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message, int code, String path) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message, ErrorCodes.get().toString(code), path));
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, String message, int code) {
        return Utils.makeErrorObject(cx, scope, message, code, null);
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message, int code) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message, code, null));
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, int code) {
        return Utils.makeErrorObject(cx, scope, ErrorCodes.get().toString(code), ErrorCodes.get().toString(code), null);
    }

    public static RhinoException makeError(Context cx, Scriptable scope, int code) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, code));
    }

    public static RhinoException makeError(Context cx, Scriptable scope, String message, String code) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, message, code));
    }

    public static RhinoException makeError(Context cx, Scriptable scope, NodeOSException e) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, e));
    }

    public static RhinoException makeError(Context cx, Scriptable scope, OSException e) {
        return new JavaScriptException((Object)Utils.makeErrorObject(cx, scope, e));
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, NodeOSException e) {
        return Utils.makeErrorObject(cx, scope, e.getMessage(), e.getCode(), e.getPath());
    }

    public static Scriptable makeErrorObject(Context cx, Scriptable scope, OSException e) {
        return Utils.makeErrorObject(cx, scope, e.getMessage(), ErrorCodes.get().toString(e.getCode()), e.getPath());
    }

    public static RhinoException makeRangeError(Context cx, Scriptable scope, String message) {
        Scriptable err = cx.newObject(scope, "RangeError", new Object[]{message});
        return new JavaScriptException((Object)err);
    }

    public static RhinoException makeTypeError(Context cx, Scriptable scope, String message) {
        Scriptable err = cx.newObject(scope, "TypeError", new Object[]{message});
        return new JavaScriptException((Object)err);
    }

    public static List<String> toStringList(Scriptable o) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Object id : o.getIds()) {
            Object val = id instanceof Integer ? o.get(((Integer)id).intValue(), o) : o.get((String)id, o);
            ret.add(Context.toString((Object)val));
        }
        return ret;
    }

    public static ByteBuffer catBuffers(ByteBuffer b1, ByteBuffer b2) {
        return BufferUtils.catBuffers((ByteBuffer)b1, (ByteBuffer)b2);
    }

    public static CharBuffer doubleBuffer(CharBuffer b) {
        return BufferUtils.doubleBuffer((CharBuffer)b);
    }

    public static ByteBuffer doubleBuffer(ByteBuffer b) {
        return BufferUtils.doubleBuffer((ByteBuffer)b);
    }

    public static void zeroBuffer(ByteBuffer b) {
        BufferUtils.zeroBuffer((ByteBuffer)b);
    }

    public static ByteBuffer duplicateBuffer(ByteBuffer b) {
        return BufferUtils.duplicateBuffer((ByteBuffer)b);
    }

    public static String unquote(String s) {
        return StringUtils.unquote((String)s);
    }
}

