/*
 * Decompiled with CFR 0.152.
 */
package io.apigee.trireme.core;

import io.apigee.trireme.core.SubprocessPolicy;
import io.apigee.trireme.kernel.net.NetworkPolicy;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Scriptable;

public class Sandbox {
    private OutputStream stdout;
    private InputStream stdin;
    private OutputStream stderr;
    private Scriptable stdoutStream;
    private Scriptable stdinStream;
    private Scriptable stderrStream;
    private String filesystemRoot;
    private String workingDirectory;
    private ExecutorService asyncPool;
    private NetworkPolicy networkPolicy;
    private SubprocessPolicy processPolicy;
    private List<Map.Entry<String, String>> mounts;
    private boolean hideOsDetails;
    private ClassShutter extraClassShutter;
    private boolean allowJarLoading = true;
    private ClassLoaderSupplier classLoaderSupplier = null;

    public Sandbox() {
    }

    public Sandbox(Sandbox parent) {
        if (parent != null) {
            this.stdout = parent.stdout;
            this.stdin = parent.stdin;
            this.stderr = parent.stderr;
            this.stdoutStream = parent.stdoutStream;
            this.stdinStream = parent.stdinStream;
            this.stderrStream = parent.stderrStream;
            this.filesystemRoot = parent.filesystemRoot;
            this.workingDirectory = parent.workingDirectory;
            this.asyncPool = parent.asyncPool;
            this.networkPolicy = parent.networkPolicy;
            this.processPolicy = parent.processPolicy;
            this.hideOsDetails = parent.hideOsDetails;
            this.extraClassShutter = parent.extraClassShutter;
            this.allowJarLoading = parent.allowJarLoading;
            this.classLoaderSupplier = parent.classLoaderSupplier;
            if (parent.mounts != null) {
                this.mounts = new ArrayList<Map.Entry<String, String>>(parent.mounts);
            }
        }
    }

    public Sandbox setFilesystemRoot(String root) {
        this.filesystemRoot = root;
        return this;
    }

    public String getFilesystemRoot() {
        return this.filesystemRoot;
    }

    public void mount(String prefix, String target) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<Map.Entry<String, String>>();
        }
        this.mounts.add(new AbstractMap.SimpleEntry<String, String>(prefix, target));
    }

    public List<Map.Entry<String, String>> getMounts() {
        return this.mounts;
    }

    public Sandbox setWorkingDirectory(String wd) {
        this.workingDirectory = wd;
        return this;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Sandbox setStdout(OutputStream s) {
        this.stdout = s;
        return this;
    }

    public OutputStream getStdout() {
        return this.stdout;
    }

    public Sandbox setStderr(OutputStream s) {
        this.stderr = s;
        return this;
    }

    public OutputStream getStderr() {
        return this.stderr;
    }

    public Sandbox setStdin(InputStream s) {
        this.stdin = s;
        return this;
    }

    public InputStream getStdin() {
        return this.stdin;
    }

    public Sandbox setAsyncThreadPool(ExecutorService exec) {
        this.asyncPool = exec;
        return this;
    }

    public ExecutorService getAsyncThreadPool() {
        return this.asyncPool;
    }

    public Sandbox setNetworkPolicy(NetworkPolicy policy) {
        this.networkPolicy = policy;
        return this;
    }

    public NetworkPolicy getNetworkPolicy() {
        return this.networkPolicy;
    }

    public Sandbox setSubprocessPolicy(SubprocessPolicy policy) {
        this.processPolicy = policy;
        return this;
    }

    public SubprocessPolicy getSubprocessPolicy() {
        return this.processPolicy;
    }

    public Sandbox setHideOSDetails(boolean obscure) {
        this.hideOsDetails = obscure;
        return this;
    }

    public boolean isHideOSDetails() {
        return this.hideOsDetails;
    }

    public Sandbox setExtraClassShutter(ClassShutter extraClassShutter) {
        this.extraClassShutter = extraClassShutter;
        return this;
    }

    public ClassShutter getExtraClassShutter() {
        return this.extraClassShutter;
    }

    public Sandbox setAllowJarLoading(boolean allowed) {
        this.allowJarLoading = allowed;
        return this;
    }

    public boolean isAllowJarLoading() {
        return this.allowJarLoading;
    }

    public Sandbox setClassLoaderSupplier(ClassLoaderSupplier classLoaderSupplier) {
        this.classLoaderSupplier = classLoaderSupplier;
        return this;
    }

    public ClassLoaderSupplier getClassLoaderSupplier() {
        return this.classLoaderSupplier;
    }

    public static interface ClassLoaderSupplier {
        public ClassLoader getClassLoader(URL[] var1);
    }
}

