/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.converter.json;

import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.serde.BaseSerde;
import io.apicurio.registry.serde.Default4ByteIdHandler;
import io.apicurio.registry.serde.IdHandler;
import io.apicurio.registry.utils.converter.json.FormatStrategy;
import java.nio.ByteBuffer;
import java.util.Objects;

public class CompactFormatStrategy
implements FormatStrategy {
    private IdHandler idHandler;

    public CompactFormatStrategy() {
        this((IdHandler)new Default4ByteIdHandler());
    }

    public CompactFormatStrategy(IdHandler idHandler) {
        this.setIdHandler(idHandler);
    }

    public void setIdHandler(IdHandler idHandler) {
        this.idHandler = Objects.requireNonNull(idHandler);
    }

    @Override
    public byte[] fromConnectData(long contentId, byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(1 + this.idHandler.idSize() + bytes.length);
        buffer.put((byte)0);
        this.idHandler.writeId(ArtifactReference.fromContentId((Long)contentId), buffer);
        buffer.put(bytes);
        return buffer.array();
    }

    @Override
    public FormatStrategy.IdPayload toConnectData(byte[] bytes) {
        ByteBuffer buffer = BaseSerde.getByteBuffer((byte[])bytes);
        ArtifactReference reference = this.idHandler.readId(buffer);
        long contentId = reference.getContentId();
        byte[] payload = new byte[bytes.length - this.idHandler.idSize() - 1];
        buffer.get(payload);
        return new FormatStrategy.IdPayload(contentId, payload);
    }
}

