/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.serde.AbstractSerializer;
import io.apicurio.registry.serde.Default4ByteIdHandler;
import io.apicurio.registry.serde.IdHandler;
import io.apicurio.registry.serde.config.BaseKafkaSerDeConfig;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.data.KafkaSerdeMetadata;
import io.apicurio.registry.serde.data.SerdeMetadata;
import io.apicurio.registry.serde.data.SerdeRecord;
import io.apicurio.registry.serde.headers.HeadersHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;

public class KafkaSerializer<T, U>
implements Serializer<U> {
    protected final AbstractSerializer<T, U> delegatedSerializer;
    protected HeadersHandler headersHandler;

    protected KafkaSerializer(AbstractSerializer<T, U> delegatedSerializer) {
        this.delegatedSerializer = delegatedSerializer;
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        this.delegatedSerializer.configure(new SerdeConfig(configs), isKey);
        this.configure(new BaseKafkaSerDeConfig(configs), isKey);
    }

    protected void configure(BaseKafkaSerDeConfig config, boolean isKey) {
        boolean headersEnabled = config.enableHeaders();
        if (headersEnabled) {
            Object headersHandler = config.getHeadersHandler();
            Utils.instantiate(HeadersHandler.class, (Object)headersHandler, this::setHeadersHandler);
            this.headersHandler.configure(config.originals(), isKey);
        }
    }

    public void setHeadersHandler(HeadersHandler headersHandler) {
        this.headersHandler = headersHandler;
    }

    protected void serializeData(Headers headers, ParsedSchema<T> schema, U data, OutputStream out) throws IOException {
        this.delegatedSerializer.serializeData(schema, data, out);
    }

    public byte[] serialize(String topic, U data) {
        return this.delegatedSerializer.serializeData(topic, data);
    }

    public byte[] serialize(String topic, Headers headers, U data) {
        if (data == null) {
            return null;
        }
        try {
            if (this.headersHandler != null && headers != null) {
                KafkaSerdeMetadata resolverMetadata = new KafkaSerdeMetadata(topic, this.delegatedSerializer.getSerdeConfigurer().isKey(), headers);
                SchemaLookupResult schema = this.delegatedSerializer.getSerdeConfigurer().getSchemaResolver().resolveSchema((Record)new SerdeRecord((SerdeMetadata)resolverMetadata, data));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.headersHandler.writeHeaders(headers, schema.toArtifactReference());
                this.serializeData(headers, schema.getParsedSchema(), data, out);
                return out.toByteArray();
            }
            return this.delegatedSerializer.serializeData(topic, data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void close() {
        this.delegatedSerializer.getSerdeConfigurer().close();
    }

    public void as4ByteId() {
        this.delegatedSerializer.getSerdeConfigurer().setIdHandler((IdHandler)new Default4ByteIdHandler());
    }

    public SchemaResolver<T, U> getSchemaResolver() {
        return this.delegatedSerializer.getSerdeConfigurer().getSchemaResolver();
    }

    public void setSchemaResolver(SchemaResolver<T, U> schemaResolver) {
        this.delegatedSerializer.getSerdeConfigurer().setSchemaResolver(schemaResolver);
    }
}

