/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractSerializer;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.jsonschema.JsonSchemaParser;
import io.apicurio.registry.serde.jsonschema.JsonSchemaSerializerConfig;
import io.apicurio.registry.serde.jsonschema.JsonSchemaValidationUtil;
import java.io.IOException;
import java.io.OutputStream;

public class JsonSchemaSerializer<T>
extends AbstractSerializer<JsonSchema, T> {
    private ObjectMapper mapper;
    private final JsonSchemaParser<T> parser = new JsonSchemaParser();
    private Boolean validationEnabled;

    public JsonSchemaSerializer() {
    }

    public JsonSchemaSerializer(RegistryClient client, ArtifactReferenceResolverStrategy<JsonSchema, T> artifactResolverStrategy, SchemaResolver<JsonSchema, T> schemaResolver) {
        super(client, artifactResolverStrategy, schemaResolver);
    }

    public JsonSchemaSerializer(RegistryClient client) {
        super(client);
    }

    public JsonSchemaSerializer(RegistryClient client, SchemaResolver<JsonSchema, T> schemaResolver) {
        super(client, schemaResolver);
    }

    public JsonSchemaSerializer(SchemaResolver<JsonSchema, T> schemaResolver) {
        super(schemaResolver);
    }

    public JsonSchemaSerializer(RegistryClient client, Boolean validationEnabled) {
        this(client);
        this.validationEnabled = validationEnabled;
    }

    public void configure(SerdeConfig configs, boolean isKey) {
        JsonSchemaSerializerConfig config = new JsonSchemaSerializerConfig(configs.originals());
        if (this.validationEnabled == null) {
            this.validationEnabled = config.validationEnabled();
        }
        if (null == this.mapper) {
            this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
        super.configure((SerdeConfig)config, isKey);
    }

    public SchemaParser<JsonSchema, T> schemaParser() {
        return this.parser;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public void setValidationEnabled(Boolean validationEnabled) {
        this.validationEnabled = validationEnabled;
    }

    public void serializeData(ParsedSchema<JsonSchema> schema, T data, OutputStream out) throws IOException {
        byte[] dataBytes = this.mapper.writeValueAsBytes(data);
        if (this.isValidationEnabled()) {
            JsonSchemaValidationUtil.validateDataWithSchema(schema, dataBytes, this.mapper);
        }
        out.write(dataBytes);
    }
}

