/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.jsonschema;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractDeserializer;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.jsonschema.JsonSchemaDeserializerConfig;
import io.apicurio.registry.serde.jsonschema.JsonSchemaParser;
import io.apicurio.registry.serde.jsonschema.JsonSchemaValidationUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;

public class JsonSchemaDeserializer<T>
extends AbstractDeserializer<JsonSchema, T> {
    private ObjectMapper mapper;
    private Boolean validationEnabled;
    private final JsonSchemaParser<T> parser = new JsonSchemaParser();
    private Class<T> specificReturnClass;

    public JsonSchemaDeserializer() {
    }

    public JsonSchemaDeserializer(RegistryClient client, SchemaResolver<JsonSchema, T> schemaResolver) {
        super(client, schemaResolver);
    }

    public JsonSchemaDeserializer(RegistryClient client) {
        super(client);
    }

    public JsonSchemaDeserializer(SchemaResolver<JsonSchema, T> schemaResolver) {
        super(schemaResolver);
    }

    public JsonSchemaDeserializer(RegistryClient client, SchemaResolver<JsonSchema, T> schemaResolver, ArtifactReferenceResolverStrategy<JsonSchema, T> strategy) {
        super(client, strategy, schemaResolver);
    }

    public JsonSchemaDeserializer(RegistryClient client, Boolean validationEnabled) {
        this(client);
        this.validationEnabled = validationEnabled;
    }

    public void configure(SerdeConfig configs, boolean isKey) {
        JsonSchemaDeserializerConfig config = new JsonSchemaDeserializerConfig(configs.originals(), isKey);
        super.configure((SerdeConfig)config, isKey);
        if (this.validationEnabled == null) {
            this.validationEnabled = config.validationEnabled();
        }
        this.specificReturnClass = config.getSpecificReturnClass();
        if (null == this.mapper) {
            this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        }
    }

    public SchemaParser<JsonSchema, T> schemaParser() {
        return this.parser;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled != null && this.validationEnabled != false;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public void setSpecificReturnClass(Class<T> specificReturnClass) {
        this.specificReturnClass = specificReturnClass;
    }

    public Class<T> getSpecificReturnClass() {
        return this.specificReturnClass;
    }

    public T readData(ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        return this.internalReadData(schema, buffer, start, length);
    }

    private T internalReadData(ParsedSchema<JsonSchema> schema, ByteBuffer buffer, int start, int length) {
        byte[] data = new byte[length];
        System.arraycopy(buffer.array(), start, data, 0, length);
        try {
            JsonParser parser = this.mapper.getFactory().createParser(data);
            if (this.isValidationEnabled()) {
                JsonSchemaValidationUtil.validateDataWithSchema(schema, data, this.mapper);
            }
            Class messageType = null;
            if (this.specificReturnClass != null) {
                messageType = this.specificReturnClass;
            } else {
                JsonNode jsonSchema = this.mapper.readTree(schema.getRawSchema());
                String javaType = null;
                JsonNode javaTypeNode = jsonSchema.get("javaType");
                if (javaTypeNode != null && !javaTypeNode.isNull()) {
                    javaType = javaTypeNode.textValue();
                }
                Class clazz = messageType = javaType == null ? null : Utils.loadClass(javaType);
            }
            if (messageType == null) {
                return (T)this.mapper.readTree(parser);
            }
            return (T)this.mapper.readValue(parser, messageType);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

