/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import io.apicurio.registry.resolver.AbstractSchemaResolver;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactCoordinates;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceImpl;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.CreateArtifact;
import io.apicurio.registry.rest.client.models.CreateArtifactResponse;
import io.apicurio.registry.rest.client.models.CreateVersion;
import io.apicurio.registry.rest.client.models.HandleReferencesType;
import io.apicurio.registry.rest.client.models.IfArtifactExists;
import io.apicurio.registry.rest.client.models.SearchedVersion;
import io.apicurio.registry.rest.client.models.SortOrder;
import io.apicurio.registry.rest.client.models.VersionContent;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import io.apicurio.registry.rest.client.models.VersionSearchResults;
import io.apicurio.registry.rest.client.models.VersionSortBy;
import io.apicurio.registry.utils.IoUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;

public class DefaultSchemaResolver<S, T>
extends AbstractSchemaResolver<S, T> {
    private boolean autoCreateArtifact;
    private String autoCreateBehavior;
    private boolean findLatest;
    private static final Logger logger = Logger.getLogger(DefaultSchemaResolver.class.getSimpleName());

    public DefaultSchemaResolver() {
    }

    public DefaultSchemaResolver(RegistryClient client) {
        this.client = client;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void configure(Map<String, ?> configs, SchemaParser<S, T> schemaParser) {
        super.configure(configs, schemaParser);
        if (this.artifactResolverStrategy.loadSchema() && !schemaParser.supportsExtractSchemaFromData()) {
            throw new IllegalStateException("Wrong configuration");
        }
        this.autoCreateArtifact = this.config.autoRegisterArtifact();
        this.autoCreateBehavior = this.config.autoRegisterArtifactIfExists();
        this.findLatest = this.config.findLatest();
    }

    @Override
    public SchemaLookupResult<S> resolveSchema(Record<T> data) {
        Objects.requireNonNull(data);
        Objects.requireNonNull(data.payload());
        ParsedSchema parsedSchema = this.artifactResolverStrategy.loadSchema() && this.schemaParser.supportsExtractSchemaFromData() ? this.schemaParser.getSchemaFromData(data, this.resolveDereferenced) : null;
        ArtifactReference artifactReference = this.resolveArtifactReference(data, parsedSchema, false, null);
        return this.getSchemaFromCache(artifactReference).orElseGet(() -> this.getSchemaFromRegistry(parsedSchema, data, artifactReference));
    }

    private Optional<SchemaLookupResult<S>> getSchemaFromCache(ArtifactReference artifactReference) {
        if (artifactReference.getGlobalId() != null && this.schemaCache.containsByGlobalId(artifactReference.getGlobalId())) {
            return Optional.of(this.resolveSchemaByGlobalId(artifactReference.getGlobalId()));
        }
        if (artifactReference.getContentId() != null && this.schemaCache.containsByContentId(artifactReference.getContentId())) {
            return Optional.of(this.resolveSchemaByContentId(artifactReference.getContentId()));
        }
        if (artifactReference.getContentHash() != null && this.schemaCache.containsByContentHash(artifactReference.getContentHash())) {
            return Optional.of(this.resolveSchemaByContentHash(artifactReference.getContentHash()));
        }
        if (this.schemaCache.containsByArtifactCoordinates(ArtifactCoordinates.fromArtifactReference(artifactReference))) {
            return Optional.of(this.resolveSchemaByArtifactCoordinatesCached(ArtifactCoordinates.fromArtifactReference(artifactReference)));
        }
        return Optional.empty();
    }

    private SchemaLookupResult<S> getSchemaFromRegistry(ParsedSchema<S> parsedSchema, Record<T> data, ArtifactReference artifactReference) {
        if (this.autoCreateArtifact) {
            if (this.schemaParser.supportsExtractSchemaFromData()) {
                if (parsedSchema == null) {
                    parsedSchema = this.schemaParser.getSchemaFromData(data, this.resolveDereferenced);
                }
                if (parsedSchema.hasReferences()) {
                    List<SchemaLookupResult<S>> schemaLookupResults = this.handleArtifactReferences(data, parsedSchema);
                    return this.handleAutoCreateArtifact(parsedSchema, artifactReference, schemaLookupResults);
                }
                return this.handleAutoCreateArtifact(parsedSchema, artifactReference);
            }
            if (this.config.getExplicitSchemaLocation() != null && this.schemaParser.supportsGetSchemaFromLocation()) {
                parsedSchema = this.schemaParser.getSchemaFromLocation(this.config.getExplicitSchemaLocation());
                return this.handleAutoCreateArtifact(parsedSchema, artifactReference);
            }
        }
        if (this.findLatest || artifactReference.getVersion() != null) {
            return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
        }
        if (this.schemaParser.supportsExtractSchemaFromData()) {
            if (parsedSchema == null) {
                parsedSchema = this.schemaParser.getSchemaFromData(data, this.resolveDereferenced);
            }
            return this.handleResolveSchemaByContent(parsedSchema, artifactReference);
        }
        return this.resolveSchemaByCoordinates(artifactReference.getGroupId(), artifactReference.getArtifactId(), artifactReference.getVersion());
    }

    private List<SchemaLookupResult<S>> handleArtifactReferences(Record<T> data, ParsedSchema<S> parsedSchema) {
        ArrayList<SchemaLookupResult<S>> referencesLookup = new ArrayList<SchemaLookupResult<S>>();
        for (ParsedSchema<S> referencedSchema : parsedSchema.getSchemaReferences()) {
            List<SchemaLookupResult<S>> nestedReferences = this.handleArtifactReferences(data, referencedSchema);
            if (nestedReferences.isEmpty()) {
                referencesLookup.add(this.handleAutoCreateArtifact(referencedSchema, this.resolveArtifactReference(data, referencedSchema, true, referencedSchema.referenceName())));
                continue;
            }
            referencesLookup.add(this.handleAutoCreateArtifact(referencedSchema, this.resolveArtifactReference(data, referencedSchema, true, referencedSchema.referenceName()), nestedReferences));
        }
        return referencesLookup;
    }

    @Override
    public SchemaLookupResult<S> resolveSchemaByArtifactReference(ArtifactReference reference) {
        if (reference == null) {
            throw new IllegalStateException("artifact reference cannot be null");
        }
        if (reference.getContentId() != null) {
            return this.resolveSchemaByContentId(reference.getContentId());
        }
        if (reference.getContentHash() != null) {
            return this.resolveSchemaByContentHash(reference.getContentHash());
        }
        if (reference.getGlobalId() != null) {
            return this.resolveSchemaByGlobalId(reference.getGlobalId());
        }
        return this.resolveSchemaByCoordinates(reference.getGroupId(), reference.getArtifactId(), reference.getVersion());
    }

    private SchemaLookupResult<S> resolveSchemaByCoordinates(String groupId, String artifactId, String version) {
        if (artifactId == null) {
            throw new IllegalStateException("artifactId cannot be null");
        }
        ArtifactReferenceImpl reference = ArtifactReference.builder().groupId(groupId).artifactId(artifactId).version(version).build();
        return this.resolveSchemaByArtifactReferenceCached(reference);
    }

    protected SchemaLookupResult<S> resolveSchemaByContentId(long contentId) {
        return this.schemaCache.getByContentId(contentId, contentIdKey -> {
            InputStream rawSchema = null;
            ParsedSchemaImpl ps = null;
            try {
                rawSchema = this.client.ids().contentIds().byContentId(contentIdKey).get();
                List artifactReferences = this.client.ids().contentIds().byContentId(Long.valueOf(contentId)).references().get();
                Map resolvedReferences = this.resolveReferences(artifactReferences);
                byte[] schema = rawSchema.readAllBytes();
                Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
                ps = new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.contentId((long)contentIdKey).parsedSchema(ps).build();
        });
    }

    protected SchemaLookupResult<S> resolveSchemaByContentHash(String contentHash) {
        return this.schemaCache.getByContentHash(contentHash, contentHashKey -> {
            InputStream rawSchema = null;
            ParsedSchemaImpl ps = null;
            rawSchema = this.client.ids().contentHashes().byContentHash(contentHashKey).get();
            List artifactReferences = this.client.ids().contentHashes().byContentHash(contentHashKey).references().get();
            Map resolvedReferences = this.resolveReferences(artifactReferences);
            byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
            Object parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
            ps = new ParsedSchemaImpl().setParsedSchema(parsed).setRawSchema(schema);
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            return result.contentHash((String)contentHashKey).parsedSchema(ps).build();
        });
    }

    private SchemaLookupResult<S> handleResolveSchemaByContent(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            logger.info(String.format("Retrieving schema content using string: %s", rawSchemaString));
            ByteArrayInputStream is = new ByteArrayInputStream(contentKey.getBytes(StandardCharsets.UTF_8));
            String at = this.schemaParser.artifactType();
            String ct = this.toContentType(at);
            VersionSearchResults results = this.client.search().versions().post((InputStream)is, ct, config -> {
                config.queryParameters.groupId = artifactReference.getGroupId() == null ? "default" : artifactReference.getGroupId();
                config.queryParameters.artifactId = artifactReference.getArtifactId();
                config.queryParameters.canonical = true;
                config.queryParameters.artifactType = at;
                config.queryParameters.orderby = VersionSortBy.GlobalId;
                config.queryParameters.order = SortOrder.Desc;
            });
            if (results.getCount() == 0) {
                is = new ByteArrayInputStream(contentKey.getBytes(StandardCharsets.UTF_8));
                results = this.client.search().versions().post((InputStream)is, ct, config -> {
                    config.queryParameters.groupId = artifactReference.getGroupId() == null ? "default" : artifactReference.getGroupId();
                    config.queryParameters.artifactId = artifactReference.getArtifactId();
                    config.queryParameters.canonical = false;
                    config.queryParameters.artifactType = at;
                    config.queryParameters.orderby = VersionSortBy.GlobalId;
                    config.queryParameters.order = SortOrder.Desc;
                });
                if (results.getCount() == 0) {
                    throw new RuntimeException(String.format("Could not resolve artifact reference by content: %s", rawSchemaString) + "&" + artifactReference);
                }
            }
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromSearchedVersion((SearchedVersion)results.getVersions().get(0), result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private SchemaLookupResult<S> handleAutoCreateArtifact(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            CreateArtifact createArtifact = new CreateArtifact();
            createArtifact.setArtifactId(artifactReference.getArtifactId());
            createArtifact.setArtifactType(this.schemaParser.artifactType());
            CreateVersion version = new CreateVersion();
            version.setVersion(artifactReference.getVersion());
            createArtifact.setFirstVersion(version);
            VersionContent vc = new VersionContent();
            vc.setContent(rawSchemaString);
            vc.setContentType(this.toContentType(this.schemaParser.artifactType()));
            version.setContent(vc);
            CreateArtifactResponse car = this.client.groups().byGroupId(artifactReference.getGroupId() == null ? "default" : artifactReference.getGroupId()).artifacts().post(createArtifact, config -> {
                config.queryParameters.ifExists = IfArtifactExists.forValue((String)this.autoCreateBehavior);
                config.queryParameters.canonical = false;
            });
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromMetaData(car.getVersion(), result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private SchemaLookupResult<S> handleAutoCreateArtifact(ParsedSchema<S> parsedSchema, ArtifactReference artifactReference, List<SchemaLookupResult<S>> referenceLookups) {
        String rawSchemaString = IoUtil.toString((byte[])parsedSchema.getRawSchema());
        List<io.apicurio.registry.rest.client.models.ArtifactReference> artifactReferences = this.parseReferences(referenceLookups);
        return this.schemaCache.getByContent(rawSchemaString, contentKey -> {
            CreateArtifact createArtifact = new CreateArtifact();
            createArtifact.setArtifactId(artifactReference.getArtifactId());
            createArtifact.setArtifactType(this.schemaParser.artifactType());
            CreateVersion version = new CreateVersion();
            version.setVersion(artifactReference.getVersion());
            createArtifact.setFirstVersion(version);
            VersionContent vc = new VersionContent();
            vc.setContent(rawSchemaString);
            vc.setContentType(this.toContentType(this.schemaParser.artifactType()));
            vc.setReferences(artifactReferences);
            version.setContent(vc);
            CreateArtifactResponse car = this.client.groups().byGroupId(artifactReference.getGroupId() == null ? "default" : artifactReference.getGroupId()).artifacts().post(createArtifact, config -> {
                config.queryParameters.ifExists = IfArtifactExists.forValue((String)this.autoCreateBehavior);
                config.queryParameters.canonical = false;
            });
            SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
            this.loadFromMetaData(car.getVersion(), result);
            result.parsedSchema(parsedSchema);
            return result.build();
        });
    }

    private String toContentType(String artifactType) {
        if ("AVRO".equals(artifactType)) {
            return "application/json";
        }
        if ("JSON".equals(artifactType)) {
            return "application/json";
        }
        if ("PROTOBUF".equals(artifactType)) {
            return "application/x-protobuf";
        }
        if ("KCONNECT".equals(artifactType)) {
            return "application/json";
        }
        if ("OPENAPI".equals(artifactType)) {
            return "application/json";
        }
        if ("ASYNCAPI".equals(artifactType)) {
            return "application/json";
        }
        if ("WSDL".equals(artifactType)) {
            return "application/xml";
        }
        if ("XSD".equals(artifactType)) {
            return "application/xml";
        }
        if ("XML".equals(artifactType)) {
            return "application/xml";
        }
        if ("GRAPHQL".equals(artifactType)) {
            return "application/graphql";
        }
        throw new IllegalArgumentException("Artifact type not supported: " + artifactType);
    }

    private List<io.apicurio.registry.rest.client.models.ArtifactReference> parseReferences(List<SchemaLookupResult<S>> referenceLookups) {
        ArrayList<io.apicurio.registry.rest.client.models.ArtifactReference> artifactReferences = new ArrayList<io.apicurio.registry.rest.client.models.ArtifactReference>();
        referenceLookups.forEach(referenceLookup -> {
            io.apicurio.registry.rest.client.models.ArtifactReference artifactReferenceLookup = new io.apicurio.registry.rest.client.models.ArtifactReference();
            artifactReferenceLookup.setArtifactId(referenceLookup.getArtifactId());
            artifactReferenceLookup.setGroupId(referenceLookup.getGroupId());
            artifactReferenceLookup.setName(referenceLookup.getParsedSchema().referenceName());
            artifactReferenceLookup.setVersion(referenceLookup.getVersion());
            artifactReferences.add(artifactReferenceLookup);
        });
        return artifactReferences;
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactCoordinatesCached(ArtifactCoordinates artifactCoordinates) {
        return this.schemaCache.getByArtifactCoordinates(artifactCoordinates, artifactCoordinatesKey -> this.resolveByCoordinates(artifactCoordinatesKey.getGroupId(), artifactCoordinatesKey.getArtifactId(), artifactCoordinatesKey.getVersion()));
    }

    private SchemaLookupResult<S> resolveSchemaByArtifactReferenceCached(ArtifactReference artifactReference) {
        if (artifactReference.getGlobalId() != null) {
            return this.schemaCache.getByGlobalId(artifactReference.getGlobalId(), this::resolveSchemaByGlobalId);
        }
        if (artifactReference.getContentId() != null) {
            return this.schemaCache.getByContentId(artifactReference.getContentId(), this::resolveSchemaByContentId);
        }
        if (artifactReference.getContentHash() != null) {
            return this.schemaCache.getByContentHash(artifactReference.getContentHash(), this::resolveSchemaByContentHash);
        }
        return this.schemaCache.getByArtifactCoordinates(ArtifactCoordinates.fromArtifactReference(artifactReference), artifactReferenceKey -> this.resolveByCoordinates(artifactReferenceKey.getGroupId(), artifactReferenceKey.getArtifactId(), artifactReferenceKey.getVersion()));
    }

    private SchemaLookupResult<S> resolveByCoordinates(String groupId, String artifactId, String version) {
        InputStream rawSchema;
        SchemaLookupResult.SchemaLookupResultBuilder<Object> result = SchemaLookupResult.builder();
        if (version == null) {
            version = "branch=latest";
        }
        Object parsed = null;
        byte[] schema = null;
        VersionMetaData metadata = this.client.groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().byVersionExpression(version).get();
        this.loadFromMetaData(metadata, result);
        Long gid = metadata.getGlobalId();
        Map resolvedReferences = new HashMap();
        if (this.resolveDereferenced) {
            rawSchema = this.client.ids().globalIds().byGlobalId(gid).get(config -> {
                assert (config.queryParameters != null);
                config.queryParameters.references = HandleReferencesType.DEREFERENCE;
            });
        } else {
            rawSchema = this.client.ids().globalIds().byGlobalId(gid).get();
            List artifactReferences = this.client.ids().globalIds().byGlobalId(gid).references().get();
            resolvedReferences = this.resolveReferences(artifactReferences);
        }
        schema = IoUtil.toBytes((InputStream)rawSchema);
        parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        result.parsedSchema(new ParsedSchemaImpl<Object>().setParsedSchema(parsed).setRawSchema(schema));
        return result.build();
    }
}

