/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.resolver;

import com.microsoft.kiota.RequestAdapter;
import io.apicurio.registry.client.auth.VertXAuthFactory;
import io.apicurio.registry.resolver.ERCache;
import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.ParsedSchemaImpl;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.config.SchemaResolverConfig;
import io.apicurio.registry.resolver.data.Record;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.HandleReferencesType;
import io.apicurio.registry.rest.client.models.SearchedVersion;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import io.apicurio.registry.utils.IoUtil;
import io.kiota.http.vertx.VertXRequestAdapter;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractSchemaResolver<S, T>
implements SchemaResolver<S, T> {
    protected final ERCache<SchemaLookupResult<S>> schemaCache = new ERCache();
    protected SchemaResolverConfig config;
    protected SchemaParser<S, T> schemaParser;
    protected RegistryClient client;
    protected ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy;
    protected String explicitArtifactGroupId;
    protected String explicitArtifactId;
    protected String explicitArtifactVersion;
    protected Vertx vertx;
    protected boolean resolveDereferenced;

    @Override
    public void configure(Map<String, ?> configs, SchemaParser<S, T> schemaParser) {
        String artifactVersionOverride;
        String artifactIdOverride;
        this.schemaParser = schemaParser;
        if (this.vertx == null) {
            this.vertx = Vertx.vertx();
        }
        this.config = new SchemaResolverConfig(configs);
        if (this.client == null) {
            String baseUrl = this.config.getRegistryUrl();
            if (baseUrl == null) {
                throw new IllegalArgumentException("Missing registry base url, set apicurio.registry.url");
            }
            String tokenEndpoint = this.config.getTokenEndpoint();
            try {
                if (tokenEndpoint != null) {
                    this.client = this.configureClientWithBearerAuthentication(this.config, baseUrl, tokenEndpoint);
                } else {
                    String username = this.config.getAuthUsername();
                    if (username != null) {
                        this.client = this.configureClientWithBasicAuth(this.config, baseUrl, username);
                    } else {
                        VertXRequestAdapter adapter = new VertXRequestAdapter(this.vertx);
                        adapter.setBaseUrl(baseUrl);
                        this.client = new RegistryClient((RequestAdapter)adapter);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        Object ais = this.config.getArtifactResolverStrategy();
        Utils.instantiate(ArtifactReferenceResolverStrategy.class, ais, this::setArtifactResolverStrategy);
        this.schemaCache.configureLifetime(this.config.getCheckPeriod());
        this.schemaCache.configureRetryBackoff(this.config.getRetryBackoff());
        this.schemaCache.configureRetryCount(this.config.getRetryCount());
        this.schemaCache.configureCacheLatest(this.config.getCacheLatest());
        this.schemaCache.configureFaultTolerantRefresh(this.config.getFaultTolerantRefresh());
        this.schemaCache.configureGlobalIdKeyExtractor(SchemaLookupResult::getGlobalId);
        this.schemaCache.configureContentKeyExtractor(schema -> Optional.ofNullable(schema.getParsedSchema().getRawSchema()).map(IoUtil::toString).orElse(null));
        this.schemaCache.configureContentIdKeyExtractor(SchemaLookupResult::getContentId);
        this.schemaCache.configureContentHashKeyExtractor(SchemaLookupResult::getContentHash);
        this.schemaCache.configureArtifactCoordinatesKeyExtractor(SchemaLookupResult::toArtifactCoordinates);
        this.schemaCache.checkInitialized();
        String groupIdOverride = this.config.getExplicitArtifactGroupId();
        if (groupIdOverride != null) {
            this.explicitArtifactGroupId = groupIdOverride;
        }
        if ((artifactIdOverride = this.config.getExplicitArtifactId()) != null) {
            this.explicitArtifactId = artifactIdOverride;
        }
        if ((artifactVersionOverride = this.config.getExplicitArtifactVersion()) != null) {
            this.explicitArtifactVersion = artifactVersionOverride;
        }
        this.resolveDereferenced = this.config.resolveDereferenced();
    }

    @Override
    public void setClient(RegistryClient client) {
        this.client = client;
    }

    @Override
    public void setArtifactResolverStrategy(ArtifactReferenceResolverStrategy<S, T> artifactResolverStrategy) {
        this.artifactResolverStrategy = artifactResolverStrategy;
    }

    @Override
    public SchemaParser<S, T> getSchemaParser() {
        return this.schemaParser;
    }

    protected ArtifactReference resolveArtifactReference(Record<T> data, ParsedSchema<S> parsedSchema, boolean isReference, String referenceArtifactId) {
        ArtifactReference artifactReference = this.artifactResolverStrategy.artifactReference(data, parsedSchema);
        artifactReference = ArtifactReference.builder().groupId(this.explicitArtifactGroupId == null ? artifactReference.getGroupId() : this.explicitArtifactGroupId).artifactId(this.resolveArtifactId(artifactReference.getArtifactId(), isReference, referenceArtifactId)).version(this.explicitArtifactVersion == null ? artifactReference.getVersion() : this.explicitArtifactVersion).build();
        return artifactReference;
    }

    protected String resolveArtifactId(String artifactId, boolean isReference, String referenceArtifactId) {
        if (isReference) {
            return referenceArtifactId;
        }
        return this.explicitArtifactId == null ? artifactId : this.explicitArtifactId;
    }

    protected SchemaLookupResult<S> resolveSchemaByGlobalId(long globalId) {
        return this.schemaCache.getByGlobalId(globalId, globalIdKey -> {
            if (this.resolveDereferenced) {
                return this.resolveSchemaDereferenced((long)globalIdKey);
            }
            return this.resolveSchemaWithReferences((long)globalIdKey);
        });
    }

    private SchemaLookupResult<S> resolveSchemaDereferenced(long globalId) {
        InputStream rawSchema = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).get(config -> {
            config.headers.add("CANONICAL", "false");
            assert (config.queryParameters != null);
            config.queryParameters.references = HandleReferencesType.DEREFERENCE;
        });
        byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
        S parsed = this.schemaParser.parseSchema(schema, Collections.emptyMap());
        ParsedSchemaImpl ps = new ParsedSchemaImpl<S>().setParsedSchema(parsed).setRawSchema(schema);
        SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
        return result.globalId(globalId).parsedSchema(ps).build();
    }

    private SchemaLookupResult<S> resolveSchemaWithReferences(long globalId) {
        InputStream rawSchema = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).get(config -> config.headers.add("CANONICAL", "false"));
        List artifactReferences = this.client.ids().globalIds().byGlobalId(Long.valueOf(globalId)).references().get();
        Map<String, ParsedSchema<S>> resolvedReferences = this.resolveReferences(artifactReferences);
        byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
        S parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        ParsedSchemaImpl ps = new ParsedSchemaImpl<S>().setParsedSchema(parsed).setSchemaReferences(new ArrayList(resolvedReferences.values())).setRawSchema(schema);
        SchemaLookupResult.SchemaLookupResultBuilder result = SchemaLookupResult.builder();
        return result.globalId(globalId).parsedSchema(ps).build();
    }

    protected Map<String, ParsedSchema<S>> resolveReferences(List<io.apicurio.registry.rest.client.models.ArtifactReference> artifactReferences) {
        HashMap<String, ParsedSchema<S>> resolvedReferences = new HashMap<String, ParsedSchema<S>>();
        artifactReferences.forEach(reference -> {
            InputStream referenceContent = this.client.groups().byGroupId(reference.getGroupId() == null ? "default" : reference.getGroupId()).artifacts().byArtifactId(reference.getArtifactId()).versions().byVersionExpression(reference.getVersion()).content().get();
            List referenceReferences = this.client.groups().byGroupId(reference.getGroupId() == null ? "default" : reference.getGroupId()).artifacts().byArtifactId(reference.getArtifactId()).versions().byVersionExpression(reference.getVersion()).references().get();
            if (!referenceReferences.isEmpty()) {
                Map<String, ParsedSchema<S>> nestedReferences = this.resolveReferences(referenceReferences);
                resolvedReferences.putAll(nestedReferences);
                resolvedReferences.put(reference.getName(), this.parseSchemaFromStream(reference.getName(), referenceContent, this.resolveReferences(referenceReferences)));
            } else {
                resolvedReferences.put(reference.getName(), this.parseSchemaFromStream(reference.getName(), referenceContent, Collections.emptyMap()));
            }
        });
        return resolvedReferences;
    }

    private ParsedSchema<S> parseSchemaFromStream(String name, InputStream rawSchema, Map<String, ParsedSchema<S>> resolvedReferences) {
        byte[] schema = IoUtil.toBytes((InputStream)rawSchema);
        S parsed = this.schemaParser.parseSchema(schema, resolvedReferences);
        return new ParsedSchemaImpl<S>().setParsedSchema(parsed).setSchemaReferences(new ArrayList(resolvedReferences.values())).setReferenceName(name).setRawSchema(schema);
    }

    @Override
    public void reset() {
        this.schemaCache.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.vertx != null) {
            this.vertx.close();
        }
    }

    private RegistryClient configureClientWithBearerAuthentication(SchemaResolverConfig config, String registryUrl, String tokenEndpoint) {
        RequestAdapter auth = this.configureAuthWithUrl(config, tokenEndpoint);
        auth.setBaseUrl(registryUrl);
        return new RegistryClient(auth);
    }

    private RequestAdapter configureAuthWithUrl(SchemaResolverConfig config, String tokenEndpoint) {
        String clientId = config.getAuthClientId();
        if (clientId == null) {
            throw new IllegalArgumentException("Missing registry auth clientId, set apicurio.registry.auth.client.id");
        }
        String clientSecret = config.getAuthClientSecret();
        if (clientSecret == null) {
            throw new IllegalArgumentException("Missing registry auth secret, set apicurio.registry.auth.client.secret");
        }
        String clientScope = config.getAuthClientScope();
        return new VertXRequestAdapter(VertXAuthFactory.buildOIDCWebClient((Vertx)this.vertx, (String)tokenEndpoint, (String)clientId, (String)clientSecret, (String)clientScope));
    }

    private RegistryClient configureClientWithBasicAuth(SchemaResolverConfig config, String registryUrl, String username) {
        String password = config.getAuthPassword();
        if (password == null) {
            throw new IllegalArgumentException("Missing registry auth password, set apicurio.registry.auth.password");
        }
        VertXRequestAdapter adapter = new VertXRequestAdapter(VertXAuthFactory.buildSimpleAuthWebClient((Vertx)this.vertx, (String)username, (String)password));
        adapter.setBaseUrl(registryUrl);
        return new RegistryClient((RequestAdapter)adapter);
    }

    protected void loadFromMetaData(VersionMetaData artifactMetadata, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(artifactMetadata.getGlobalId());
        resultBuilder.contentId(artifactMetadata.getContentId());
        resultBuilder.groupId(artifactMetadata.getGroupId());
        resultBuilder.artifactId(artifactMetadata.getArtifactId());
        resultBuilder.version(String.valueOf(artifactMetadata.getVersion()));
    }

    protected void loadFromSearchedVersion(SearchedVersion version, SchemaLookupResult.SchemaLookupResultBuilder<S> resultBuilder) {
        resultBuilder.globalId(version.getGlobalId());
        resultBuilder.contentId(version.getContentId());
        resultBuilder.groupId(version.getGroupId());
        resultBuilder.artifactId(version.getArtifactId());
        resultBuilder.version(String.valueOf(version.getVersion()));
    }
}

