/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rest.v1;

import io.apicurio.registry.rest.v1.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v1.beans.EditableMetaData;
import io.apicurio.registry.rest.v1.beans.IfExistsType;
import io.apicurio.registry.rest.v1.beans.Rule;
import io.apicurio.registry.rest.v1.beans.UpdateState;
import io.apicurio.registry.rest.v1.beans.VersionMetaData;
import io.apicurio.registry.types.RuleType;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.List;

@Path(value="/apis/registry/v1/artifacts")
public interface ArtifactsResource {
    @GET
    @Produces(value={"application/json"})
    public List<String> listArtifacts();

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public ArtifactMetaData createArtifact(@HeaderParam(value="X-Registry-ArtifactType") String var1, @HeaderParam(value="X-Registry-ArtifactId") String var2, @DefaultValue(value="FAIL") @QueryParam(value="ifExists") IfExistsType var3, @QueryParam(value="canonical") Boolean var4, InputStream var5);

    @Path(value="/{artifactId}")
    @GET
    @Produces(value={"application/json", "application/x-protobuf", "application/x-protobuffer", "application/xml", "application/graphql"})
    public Response getLatestArtifact(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public ArtifactMetaData updateArtifact(@PathParam(value="artifactId") String var1, @HeaderParam(value="X-Registry-ArtifactType") String var2, InputStream var3);

    @Path(value="/{artifactId}")
    @DELETE
    public void deleteArtifact(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactState(@PathParam(value="artifactId") String var1, UpdateState var2);

    @Path(value="/{artifactId}/meta")
    @GET
    @Produces(value={"application/json"})
    public ArtifactMetaData getArtifactMetaData(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactMetaData(@PathParam(value="artifactId") String var1, EditableMetaData var2);

    @Path(value="/{artifactId}/meta")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public VersionMetaData getArtifactVersionMetaDataByContent(@PathParam(value="artifactId") String var1, @QueryParam(value="canonical") Boolean var2, InputStream var3);

    @Path(value="/{artifactId}/versions")
    @GET
    @Produces(value={"application/json"})
    public List<Long> listArtifactVersions(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/versions")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"*/*"})
    public VersionMetaData createArtifactVersion(@PathParam(value="artifactId") String var1, @HeaderParam(value="X-Registry-ArtifactType") String var2, InputStream var3);

    @Path(value="/{artifactId}/versions/{version}")
    @GET
    @Produces(value={"application/json", "application/x-protobuf", "application/x-protobuffer", "application/xml", "application/graphql"})
    public Response getArtifactVersion(@PathParam(value="artifactId") String var1, @PathParam(value="version") Integer var2);

    @Path(value="/{artifactId}/versions/{version}/state")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionState(@PathParam(value="artifactId") String var1, @PathParam(value="version") Integer var2, UpdateState var3);

    @Path(value="/{artifactId}/versions/{version}/meta")
    @GET
    @Produces(value={"application/json"})
    public VersionMetaData getArtifactVersionMetaData(@PathParam(value="artifactId") String var1, @PathParam(value="version") Integer var2);

    @Path(value="/{artifactId}/versions/{version}/meta")
    @PUT
    @Consumes(value={"application/json"})
    public void updateArtifactVersionMetaData(@PathParam(value="artifactId") String var1, @PathParam(value="version") Integer var2, EditableMetaData var3);

    @Path(value="/{artifactId}/versions/{version}/meta")
    @DELETE
    public void deleteArtifactVersionMetaData(@PathParam(value="artifactId") String var1, @PathParam(value="version") Integer var2);

    @Path(value="/{artifactId}/rules")
    @GET
    @Produces(value={"application/json"})
    public List<RuleType> listArtifactRules(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/rules")
    @POST
    @Consumes(value={"application/json"})
    public void createArtifactRule(@PathParam(value="artifactId") String var1, Rule var2);

    @Path(value="/{artifactId}/rules")
    @DELETE
    public void deleteArtifactRules(@PathParam(value="artifactId") String var1);

    @Path(value="/{artifactId}/rules/{rule}")
    @GET
    @Produces(value={"application/json"})
    public Rule getArtifactRuleConfig(@PathParam(value="artifactId") String var1, @PathParam(value="rule") RuleType var2);

    @Path(value="/{artifactId}/rules/{rule}")
    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Rule updateArtifactRuleConfig(@PathParam(value="artifactId") String var1, @PathParam(value="rule") RuleType var2, Rule var3);

    @Path(value="/{artifactId}/rules/{rule}")
    @DELETE
    public void deleteArtifactRule(@PathParam(value="artifactId") String var1, @PathParam(value="rule") RuleType var2);

    @Path(value="/{artifactId}/test")
    @PUT
    @Consumes(value={"*/*"})
    public void testUpdateArtifact(@PathParam(value="artifactId") String var1, @HeaderParam(value="X-Registry-ArtifactType") String var2, InputStream var3);
}

