/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde.avro;

import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.AbstractDeserializer;
import io.apicurio.registry.serde.KafkaDeserializer;
import io.apicurio.registry.serde.avro.AvroDeserializer;
import io.apicurio.registry.serde.avro.AvroEncoding;
import io.apicurio.registry.serde.avro.AvroSerdeHeaders;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.kafka.common.header.Headers;

public class AvroKafkaDeserializer<U>
extends KafkaDeserializer<Schema, U> {
    private AvroSerdeHeaders avroHeaders;

    public AvroKafkaDeserializer() {
        super((AbstractDeserializer)new AvroDeserializer());
    }

    public AvroKafkaDeserializer(RegistryClient client) {
        super((AbstractDeserializer)new AvroDeserializer(client));
    }

    public AvroKafkaDeserializer(SchemaResolver<Schema, U> schemaResolver) {
        super((AbstractDeserializer)new AvroDeserializer(schemaResolver));
    }

    public AvroKafkaDeserializer(RegistryClient client, SchemaResolver<Schema, U> schemaResolver) {
        super((AbstractDeserializer)new AvroDeserializer(client, schemaResolver));
    }

    public AvroKafkaDeserializer(RegistryClient client, ArtifactReferenceResolverStrategy<Schema, U> strategy, SchemaResolver<Schema, U> schemaResolver) {
        super((AbstractDeserializer)new AvroDeserializer(client, strategy, schemaResolver));
    }

    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
        this.avroHeaders = new AvroSerdeHeaders(isKey);
    }

    public U deserialize(String topic, Headers headers, byte[] data) {
        String encodingHeader;
        AvroEncoding encoding = null;
        if (headers != null && (encodingHeader = this.avroHeaders.getEncoding(headers)) != null) {
            encoding = AvroEncoding.valueOf((String)encodingHeader);
        }
        if (encoding != null) {
            ((AvroDeserializer)this.delegatedDeserializer).setEncoding(encoding);
        }
        return (U)super.deserialize(topic, headers, data);
    }
}

