/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.support.utils;

import io.alauda.jenkins.devops.support.KubernetesCluster;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jenkins.model.Jenkins;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SyncPluginConfigurationCompatiblilityMigrater {
    private static final Logger logger = Logger.getLogger(SyncPluginConfigurationCompatiblilityMigrater.class.getName());
    private static final String SYNC_PLUGIN_CONFIGURATION_FILE_NAME = "io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration.xml";

    public static KubernetesCluster migrateConfigurationFromSyncPlugin() {
        File configFile = new File(Jenkins.getInstance().getRootDir(), SYNC_PLUGIN_CONFIGURATION_FILE_NAME);
        if (!configFile.exists() || !configFile.isFile()) {
            return null;
        }
        try {
            Document configDocument = SyncPluginConfigurationCompatiblilityMigrater.readFileToXMLDocument(configFile);
            Element documentElement = configDocument.getDocumentElement();
            if (documentElement == null) {
                return null;
            }
            KubernetesCluster cluster = new KubernetesCluster();
            NodeList trustCertsNodeList = configDocument.getElementsByTagName("trustCerts");
            if (trustCertsNodeList == null || trustCertsNodeList.getLength() == 0) {
                return null;
            }
            String trustCertsStr = trustCertsNodeList.item(0).getTextContent();
            if (!"true".equals(trustCertsStr) && !"false".equals(trustCertsStr)) {
                return null;
            }
            cluster.setSkipTlsVerify(Boolean.parseBoolean(trustCertsStr));
            SyncPluginConfigurationCompatiblilityMigrater.removeNodeList(trustCertsNodeList);
            NodeList serverNodeList = configDocument.getElementsByTagName("server");
            if (serverNodeList == null || serverNodeList.getLength() == 0) {
                return null;
            }
            cluster.setMasterUrl(serverNodeList.item(0).getTextContent());
            SyncPluginConfigurationCompatiblilityMigrater.removeNodeList(serverNodeList);
            NodeList credentialsNodeList = configDocument.getElementsByTagName("credentialsId");
            if (credentialsNodeList != null && credentialsNodeList.getLength() > 0) {
                cluster.setCredentialsId(credentialsNodeList.item(0).getTextContent());
                SyncPluginConfigurationCompatiblilityMigrater.removeNodeList(credentialsNodeList);
            }
            SyncPluginConfigurationCompatiblilityMigrater.writeXMLDocumentToFile(configDocument, configFile);
            return cluster;
        }
        catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
            logger.log(Level.FINE, String.format("Unable to migrate configuration from old sync plugin, will skip it, reason: %s", e.getMessage()), e);
            return null;
        }
    }

    private static Document readFileToXMLDocument(File xml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            logger.log(Level.WARNING, "Failed to set FEATURE_SECURE_PROCESSING to true", e);
        }
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(xml);
    }

    private static void writeXMLDocumentToFile(Document document, File xml) throws TransformerException, IOException {
        Transformer transformer = SyncPluginConfigurationCompatiblilityMigrater.newSecureTransformerFactory().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult((Writer)new FileWriterWithEncoding(xml, StandardCharsets.UTF_8));
        DOMSource source = new DOMSource(document);
        transformer.transform(source, result);
    }

    private static void removeNodeList(NodeList nodeList) {
        if (nodeList == null) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            nodeList.item(i).getParentNode().removeChild(nodeList.item(i));
        }
    }

    private static TransformerFactory newSecureTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        }
        return transformerFactory;
    }
}

