/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.support;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.alauda.jenkins.devops.support.client.Clients;
import io.alauda.jenkins.devops.support.exception.KubernetesClientException;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1NamespaceList;
import java.util.Objects;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubernetesCluster
extends AbstractDescribableImpl<KubernetesCluster> {
    private String masterUrl;
    private String credentialsId;
    private boolean skipTlsVerify = false;
    private String serverCertificateAuthority;
    private boolean defaultCluster = false;
    private boolean managerCluster = false;

    @DataBoundConstructor
    public KubernetesCluster() {
    }

    public String getMasterUrl() {
        return this.masterUrl;
    }

    @DataBoundSetter
    public void setMasterUrl(String masterUrl) {
        this.masterUrl = masterUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialId) {
        this.credentialsId = credentialId;
    }

    public boolean isSkipTlsVerify() {
        return this.skipTlsVerify;
    }

    @DataBoundSetter
    public void setSkipTlsVerify(boolean skipTlsVerify) {
        this.skipTlsVerify = skipTlsVerify;
    }

    public String getServerCertificateAuthority() {
        return this.serverCertificateAuthority;
    }

    @DataBoundSetter
    public void setServerCertificateAuthority(String serverCertificateAuthority) {
        this.serverCertificateAuthority = serverCertificateAuthority;
    }

    public boolean isDefaultCluster() {
        return this.defaultCluster;
    }

    @DataBoundSetter
    public void setDefaultCluster(boolean defaultCluster) {
        this.defaultCluster = defaultCluster;
    }

    public boolean isManagerCluster() {
        return this.managerCluster;
    }

    @DataBoundSetter
    public void setManagerCluster(boolean managerCluster) {
        this.managerCluster = managerCluster;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KubernetesCluster cluster = (KubernetesCluster)((Object)o);
        return this.skipTlsVerify == cluster.skipTlsVerify && this.defaultCluster == cluster.defaultCluster && this.managerCluster == cluster.managerCluster && Objects.equals(this.masterUrl, cluster.masterUrl) && Objects.equals(this.credentialsId, cluster.credentialsId) && Objects.equals(this.serverCertificateAuthority, cluster.serverCertificateAuthority);
    }

    public int hashCode() {
        return Objects.hash(this.masterUrl, this.credentialsId, this.skipTlsVerify, this.serverCertificateAuthority, this.defaultCluster, this.managerCluster);
    }

    @Extension
    public static class AlaudaDevOpsK8sServerDescriptor
    extends Descriptor<KubernetesCluster> {
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId) {
            if (credentialsId == null) {
                credentialsId = "";
            }
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), StringCredentials.class).includeCurrentValue(credentialsId);
        }

        public FormValidation doVerifyConnect(@QueryParameter String masterUrl, @QueryParameter String credentialsId, @QueryParameter String serverCertificateAuthority, @QueryParameter boolean skipTlsVerify) {
            V1NamespaceList list;
            ApiClient testClient;
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                testClient = Clients.createClientFromConfig(masterUrl, credentialsId, serverCertificateAuthority, skipTlsVerify);
            }
            catch (KubernetesClientException e) {
                e.printStackTrace();
                return FormValidation.error((String)e.getMessage());
            }
            CoreV1Api api = new CoreV1Api(testClient);
            try {
                list = api.listNamespace(null, null, null, null, null, null, null, null);
            }
            catch (ApiException e) {
                return FormValidation.error((String)e.getMessage());
            }
            if (list == null) {
                return FormValidation.error((String)String.format("Unable to connect to cluster %s", masterUrl));
            }
            return FormValidation.ok((String)String.format("Connect to %s succeed", masterUrl));
        }
    }
}

