/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import io.alauda.devops.java.client.models.V1alpha1LocalObjectReference;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineBuilder;
import io.alauda.devops.java.client.models.V1alpha1PipelineCause;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigSpec;
import io.alauda.devops.java.client.models.V1alpha1PipelineParameter;
import io.alauda.devops.java.client.models.V1alpha1PipelineSpec;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.multiBranch.PullRequest;
import io.alauda.jenkins.devops.sync.util.ParameterUtils;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.validation.constraints.NotNull;
import jenkins.branch.Branch;
import jenkins.branch.BranchIndexingCause;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.multibranch.BranchJobProperty;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public abstract class PipelineGenerator {
    private static final Logger LOGGER = Logger.getLogger(PipelineGenerator.class.getName());
    private static String TRIGGER_BY = "Triggered by Jenkins job at ";

    public static V1alpha1Pipeline buildPipeline(V1alpha1PipelineConfig config, List<Action> actions) throws ApiException {
        return PipelineGenerator.buildPipeline(config, null, actions);
    }

    public static V1alpha1Pipeline buildPipeline(V1alpha1PipelineConfig config, @NotNull WorkflowJob job, String triggerURL, List<Action> actions) throws ApiException {
        BranchJobProperty property;
        ItemGroup parent = job.getParent();
        HashMap<String, String> annotations = new HashMap<String, String>();
        if (parent instanceof WorkflowMultiBranchProject && (property = (BranchJobProperty)job.getProperty(BranchJobProperty.class)) != null) {
            PullRequest pr;
            Branch branch = property.getBranch();
            annotations.put("alauda.io/multiBranchName", branch.getName());
            String scmURL = "";
            ObjectMetadataAction metadataAction = (ObjectMetadataAction)job.getAction(ObjectMetadataAction.class);
            if (metadataAction != null) {
                scmURL = metadataAction.getObjectUrl();
            }
            if ((pr = PipelineGenerator.getPR((Item)job)) != null) {
                pr.setUrl(scmURL);
                annotations.put("alauda.io/multiBranchCategory", "pr");
                annotations.put("alauda.io/jenkins.pr.detail", JSONObject.fromObject((Object)pr).toString());
            } else {
                annotations.put("alauda.io/multiBranchCategory", "branch");
            }
        }
        return PipelineGenerator.buildPipeline(config, annotations, triggerURL, actions);
    }

    public static PullRequest getPR(Item item) {
        PullRequest pr = null;
        SCMHead head = SCMHead.HeadByItem.findHead((Item)item);
        if (!(head instanceof ChangeRequestSCMHead)) {
            return pr;
        }
        pr = new PullRequest();
        ChangeRequestSCMHead prHead = (ChangeRequestSCMHead)head;
        pr.setTargetBranch(prHead.getTarget().getName());
        pr.setId(prHead.getId());
        if (head instanceof ChangeRequestSCMHead2) {
            pr.setSourceBranch(((ChangeRequestSCMHead2)head).getOriginName());
        }
        return pr;
    }

    @Deprecated
    public static V1alpha1Pipeline buildPipeline(V1alpha1PipelineConfig config, String triggerURL, List<Action> actions) throws ApiException {
        return PipelineGenerator.buildPipeline(config, new HashMap<String, String>(), triggerURL, actions);
    }

    private static String causeConvert(Cause cause) {
        String causeName = null;
        causeName = cause instanceof SCMTrigger.SCMTriggerCause ? "codeChange" : (cause instanceof TimerTrigger.TimerTriggerCause ? "cron" : (cause instanceof BranchIndexingCause ? "branchScan" : (cause instanceof Cause.UpstreamCause ? "upstreamCause" : "unknownCause")));
        return causeName;
    }

    private static V1alpha1Pipeline buildPipeline(V1alpha1PipelineConfig config, Map<String, String> annotations, String triggerURL, List<Action> actions) throws ApiException {
        V1alpha1PipelineSpec pipelineSpec = PipelineGenerator.buildPipelineSpec(config, triggerURL);
        ArrayList allCauses = new ArrayList();
        for (Action action : actions) {
            if (!(action instanceof CauseAction)) continue;
            CauseAction causeAction = (CauseAction)action;
            allCauses.addAll(causeAction.getCauses());
        }
        String cause = null;
        if (allCauses.size() > 1) {
            cause = "multiCauses";
            annotations.put("alauda.io/causes-details", JSONObject.fromObject(allCauses).toString());
        } else {
            cause = allCauses.size() == 1 ? PipelineGenerator.causeConvert((Cause)allCauses.get(0)) : "noCauseFound";
        }
        V1alpha1PipelineCause pipelineCause = new V1alpha1PipelineCause().type(cause).message(TRIGGER_BY + triggerURL);
        pipelineSpec.setCause(pipelineCause);
        for (Action action : actions) {
            ParametersAction paramAction;
            if (!(action instanceof ParametersAction) || (paramAction = (ParametersAction)action).getParameters() == null) continue;
            ArrayList<V1alpha1PipelineParameter> parameters = new ArrayList<V1alpha1PipelineParameter>();
            for (ParameterValue param : paramAction.getParameters()) {
                V1alpha1PipelineParameter pipeParam = ParameterUtils.to(param);
                if (pipeParam == null) continue;
                parameters.add(pipeParam);
            }
            pipelineSpec.setParameters(parameters);
        }
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("created_by", "sync.plugin.alauda.io");
        String namespace = config.getMetadata().getNamespace();
        V1alpha1Pipeline pipe = ((V1alpha1PipelineBuilder)((V1alpha1PipelineBuilder)new V1alpha1PipelineBuilder().withMetadata(((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)((V1ObjectMetaBuilder)new V1ObjectMetaBuilder().withName(config.getMetadata().getName())).withNamespace(namespace)).addToAnnotations(annotations)).addToLabels(labels)).build())).withSpec(pipelineSpec)).build();
        return Clients.get(V1alpha1Pipeline.class).create(pipe);
    }

    public static V1alpha1PipelineSpec buildPipelineSpec(V1alpha1PipelineConfig config) {
        return PipelineGenerator.buildPipelineSpec(config, null);
    }

    private static V1alpha1PipelineSpec buildPipelineSpec(V1alpha1PipelineConfig config, String triggerURL) {
        V1alpha1PipelineSpec pipeSpec = new V1alpha1PipelineSpec();
        V1alpha1PipelineConfigSpec spec = config.getSpec();
        pipeSpec.setPipelineConfig(new V1alpha1LocalObjectReference().name(config.getMetadata().getName()));
        pipeSpec.setJenkinsBinding(spec.getJenkinsBinding());
        pipeSpec.setRunPolicy(spec.getRunPolicy());
        pipeSpec.setTriggers(spec.getTriggers());
        pipeSpec.setStrategy(spec.getStrategy());
        pipeSpec.setHooks(spec.getHooks());
        pipeSpec.setSource(spec.getSource());
        return pipeSpec;
    }
}

