/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.util;

import hudson.Plugin;
import hudson.util.VersionNumber;
import io.alauda.devops.java.client.models.V1alpha1Condition;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfigTemplate;
import io.alauda.devops.java.client.models.V1alpha1PipelineDependency;
import io.alauda.jenkins.devops.sync.util.CollectionUtils;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import jenkins.model.Jenkins;

public abstract class PipelineConfigUtils {
    private static final Logger logger = Logger.getLogger(PipelineConfigUtils.class.getName());

    private PipelineConfigUtils() {
    }

    public static boolean isSerialPolicy(V1alpha1PipelineConfig pipelineConfig) {
        if (pipelineConfig == null) {
            throw new IllegalArgumentException("param can't be null");
        }
        return "Serial".equals(pipelineConfig.getSpec().getRunPolicy());
    }

    public static boolean isParallel(V1alpha1PipelineConfig pipelineConfig) {
        if (pipelineConfig == null) {
            throw new IllegalArgumentException("param can't be null");
        }
        return "Parallel".equals(pipelineConfig.getSpec().getRunPolicy());
    }

    public static void dependencyCheck(@Nonnull V1alpha1PipelineConfig pipelineConfig, @Nonnull List<V1alpha1Condition> conditions) {
        boolean fromTpl = PipelineConfigUtils.createFromTpl(pipelineConfig);
        if (!fromTpl) {
            return;
        }
        V1alpha1PipelineConfigTemplate template = pipelineConfig.getSpec().getStrategy().getTemplate();
        V1alpha1PipelineDependency dependencies = template.getSpec().getDependencies();
        if (dependencies == null || CollectionUtils.isEmpty(dependencies.getPlugins())) {
            logger.info("PipelineConfig " + pipelineConfig.getMetadata().getName() + " no any dependencies.");
            return;
        }
        Jenkins jenkins = Jenkins.getInstance();
        dependencies.getPlugins().forEach(plugin -> {
            String name = plugin.getName();
            String version = plugin.getVersion();
            VersionNumber verNumber = new VersionNumber(version);
            V1alpha1Condition condition = new V1alpha1Condition();
            condition.setReason("plugin dependencies error");
            Plugin existsPlugin = jenkins.getPlugin(name);
            if (existsPlugin == null) {
                condition.setMessage(String.format("Lack plugin: %s, version: %s", name, version));
            } else {
                VersionNumber currentNumber = existsPlugin.getWrapper().getVersionNumber();
                if (currentNumber.isOlderThan(verNumber)) {
                    condition.setMessage(String.format("Require plugin: %s, version: %s, found %s", name, version, currentNumber));
                }
            }
            if (condition.getMessage() != null) {
                conditions.add(condition);
            }
        });
    }

    public static boolean createFromTpl(@Nonnull V1alpha1PipelineConfig pipelineConfig) {
        V1alpha1PipelineConfigTemplate template = pipelineConfig.getSpec().getStrategy().getTemplate();
        return template != null && template.getSpec() != null;
    }

    public static boolean isMultiBranch(@NotNull V1alpha1PipelineConfig pipelineConfig) {
        Map labels = pipelineConfig.getMetadata().getLabels();
        return labels != null && "multi-branch".equals(labels.get("pipeline.kind"));
    }
}

