/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.mapper.converter;

import hudson.Extension;
import io.alauda.jenkins.devops.sync.constants.CodeRepoServices;
import io.alauda.jenkins.devops.sync.mapper.converter.GitProviderMultiBranch;
import java.lang.reflect.InvocationTargetException;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Restricted(value={NoExternalUse.class})
public class GitHubMultiBranch
implements GitProviderMultiBranch {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubMultiBranch.class);

    @Override
    public boolean accept(String type) {
        return CodeRepoServices.Github.name().equals(type);
    }

    @Override
    public SCMSource getSCMSource(String repoOwner, String repository) {
        try {
            Class<?> scmSource = this.loadClass("org.jenkinsci.plugins.github_branch_source.GitHubSCMSource");
            return (SCMSource)scmSource.getConstructor(String.class, String.class).newInstance(repoOwner, repository);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getSCMSource", (Throwable)e);
            return null;
        }
    }

    @Override
    public SCMSourceTrait getBranchDiscoverTrait(int code) {
        try {
            Class<?> discoverBranchClz = this.loadClass("org.jenkinsci.plugins.github_branch_source.BranchDiscoveryTrait");
            return (SCMSourceTrait)discoverBranchClz.getConstructor(Integer.TYPE).newInstance(code);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getBranchDiscoverTrait", (Throwable)e);
            return null;
        }
    }

    @Override
    public SCMSourceTrait getOriginPRTrait(int code) {
        try {
            Class<?> discoverBranchClz = this.loadClass("org.jenkinsci.plugins.github_branch_source.OriginPullRequestDiscoveryTrait");
            return (SCMSourceTrait)discoverBranchClz.getConstructor(Integer.TYPE).newInstance(code);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getOriginPRTrait", (Throwable)e);
            return null;
        }
    }

    @Override
    public SCMSourceTrait getForkPRTrait(int code) {
        try {
            Class<?> discoverBranchClz = this.loadClass("org.jenkinsci.plugins.github_branch_source.ForkPullRequestDiscoveryTrait");
            Class<?> trustClz = this.loadClass("org.jenkinsci.plugins.github_branch_source.ForkPullRequestDiscoveryTrait$TrustPermission");
            return (SCMSourceTrait)discoverBranchClz.getConstructor(Integer.TYPE, SCMHeadAuthority.class).newInstance(code, trustClz.newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOGGER.warn("Exception happened while getForkPRTrait", (Throwable)e);
            return null;
        }
    }
}

