/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.folder;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import hudson.Extension;
import hudson.Util;
import hudson.model.Cause;
import hudson.model.Item;
import hudson.model.Items;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.triggers.Messages;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CronFolderTrigger
extends Trigger<ComputedFolder<?>> {
    private static final Logger LOGGER = Logger.getLogger(CronFolderTrigger.class.getName());
    private String crontab;
    private boolean enabled;

    @DataBoundConstructor
    public CronFolderTrigger(String crontab, boolean enabled) throws ANTLRException {
        super(crontab);
        this.crontab = crontab;
        this.enabled = enabled;
    }

    public void run() {
        if (this.job == null || !this.enabled) {
            LOGGER.info("Job is null or current trigger is disabled.");
            return;
        }
        ((ComputedFolder)this.job).scheduleBuild(0, (Cause)new TimerTrigger.TimerTriggerCause());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCrontab() {
        return this.crontab;
    }

    @Extension
    public static class DescriptorImpl
    extends TriggerDescriptor {
        public boolean isApplicable(Item item) {
            return item instanceof ComputedFolder;
        }

        public FormValidation doCheckCrontab(@QueryParameter String value, @AncestorInPath Item item) {
            try {
                CronTabList ctl = CronTabList.create((String)Util.fixNull((String)value), item != null ? Hash.from((String)item.getFullName()) : null);
                ArrayList validations = new ArrayList();
                return FormValidation.aggregate(validations);
            }
            catch (ANTLRException e) {
                if (value.trim().indexOf(10) == -1 && value.contains("**")) {
                    return FormValidation.error((String)Messages.TimerTrigger_MissingWhitespace());
                }
                return FormValidation.error((String)e.getMessage());
            }
        }

        public String getDisplayName() {
            return "Cron Trigger";
        }

        static {
            Items.XSTREAM2.addCompatibilityAlias("jenkins.branch.IndexAtLeastTrigger", CronFolderTrigger.class);
        }
    }
}

