/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.controller;

import hudson.Extension;
import hudson.ExtensionList;
import io.alauda.devops.java.client.apis.DevopsAlaudaIoV1alpha1Api;
import io.alauda.devops.java.client.models.V1alpha1Jenkins;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.support.KubernetesCluster;
import io.alauda.jenkins.devops.support.KubernetesClusterConfiguration;
import io.alauda.jenkins.devops.support.KubernetesClusterConfigurationListener;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncController;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.ControllerManagerBuilder;
import io.kubernetes.client.extended.wait.Wait;
import io.kubernetes.client.informer.SharedInformerFactory;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import jenkins.model.identity.IdentityRootAction;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class ResourceSyncManager
implements KubernetesClusterConfigurationListener {
    private static final Logger logger = LoggerFactory.getLogger(ResourceSyncManager.class);
    private ControllerManager controllerManager;
    private ExecutorService controllerManagerThread;
    private String pluginStatus;
    private AtomicBoolean started = new AtomicBoolean(false);

    public synchronized void onConfigChange(KubernetesCluster cluster, ApiClient client) {
        this.started.set(false);
        this.shutdown(null);
        this.controllerManagerThread = Executors.newSingleThreadExecutor();
        this.controllerManagerThread.submit(() -> {
            Wait.poll((Duration)Duration.ofMinutes(1L), (Duration)Duration.ofDays(1L), () -> {
                boolean isEnabled = AlaudaSyncGlobalConfiguration.get().isEnabled();
                if (!isEnabled) {
                    logger.warn("[ResourceSyncManager] Sync plugin is disabled, won't start controllers");
                    return false;
                }
                String jenkinsService = AlaudaSyncGlobalConfiguration.get().getJenkinsService();
                if (!this.checkJenkinsService(jenkinsService)) {
                    logger.warn("[ResourceSyncManager] The target Jenkins service {} is invalid, reason {}", (Object)jenkinsService, (Object)this.pluginStatus);
                    return false;
                }
                return true;
            });
            logger.warn("[ResourceSyncManager] Starting initialize controller manager");
            SharedInformerFactory informerFactory = new SharedInformerFactory();
            ExtensionList<ResourceSyncController> resourceSyncControllers = ResourceSyncController.all();
            logger.warn("[ResourceSyncManager] Found {} resourceSyncControllers", (Object)resourceSyncControllers.size());
            ControllerManagerBuilder controllerManagerBuilder = ControllerBuilder.controllerManagerBuilder((SharedInformerFactory)informerFactory);
            resourceSyncControllers.forEach(resourceSyncController -> resourceSyncController.add(controllerManagerBuilder, informerFactory));
            this.controllerManager = controllerManagerBuilder.build();
            this.pluginStatus = "";
            this.started.set(true);
            this.controllerManager.run();
        });
    }

    public synchronized void onConfigError(KubernetesCluster cluster, Throwable reason) {
        this.started.set(false);
        this.shutdown(reason);
    }

    public synchronized void shutdown(Throwable reason) {
        if (this.controllerManager != null) {
            this.controllerManager.shutdown();
            this.controllerManager = null;
        }
        if (this.controllerManagerThread != null && !this.controllerManagerThread.isShutdown()) {
            this.controllerManagerThread.shutdown();
        }
        if (reason == null) {
            logger.warn("[ResourceSyncManager] ResourceSyncManager is stopped, reason is null, seems stopped by user");
        } else {
            logger.warn("[ResourceSyncManager] ResourceSyncManager is stopped, reason: {}", (Object)reason.getMessage());
        }
    }

    private boolean checkJenkinsService(String jenkinsService) {
        String fingerprint;
        V1alpha1Jenkins currentJenkins;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)jenkinsService)) {
            this.pluginStatus = "[ResourceSyncManager] Plugin cannot get mapped Jenkins Service, jenkins service name in configuration is empty";
            return false;
        }
        try {
            currentJenkins = this.getJenkins(jenkinsService);
        }
        catch (ApiException e) {
            this.pluginStatus = String.format("[ResourceSyncManager] Plugin cannot get mapped Jenkins Service by name %s in devops-apiserver, reason %s, body %s", jenkinsService, e.getMessage(), e.getResponseBody());
            return false;
        }
        if (currentJenkins == null) {
            this.pluginStatus = String.format("[ResourceSyncManager] Plugin cannot to get mapped Jenkins Service by name %s in devops-apiserver, please ensure the jenkins service name is correct", jenkinsService);
            return false;
        }
        String currentFingerprint = new IdentityRootAction().getFingerprint();
        Map annotations = currentJenkins.getMetadata().getAnnotations();
        if (annotations == null || (fingerprint = (String)annotations.get("alauda.io/jenkins-instance-identity")) == null) {
            V1alpha1Jenkins newJenkins = (V1alpha1Jenkins)DeepCopyUtils.deepCopy((Object)currentJenkins);
            newJenkins.getMetadata().getAnnotations().put("alauda.io/jenkins-instance-identity", currentFingerprint);
            if (!JenkinsClient.getInstance().updateJenkins(currentJenkins, newJenkins)) {
                this.pluginStatus = String.format("[ResourceSyncManager] Unable to generate patch for Jenkins '%s', reason: %s", jenkinsService, "Patch failed");
                return false;
            }
        } else if (!StringUtils.equals((String)currentFingerprint, (String)fingerprint)) {
            this.pluginStatus = String.format("[ResourceSyncManager] Fingerprint from target Jenkins service %s does not match with current Jenkins %s.", fingerprint, currentFingerprint);
            return false;
        }
        return true;
    }

    private V1alpha1Jenkins getJenkins(String name) throws ApiException {
        DevopsAlaudaIoV1alpha1Api api = new DevopsAlaudaIoV1alpha1Api();
        return api.readJenkins(name, null, null, null);
    }

    public String getPluginStatus() {
        return this.pluginStatus;
    }

    public boolean isStarted() {
        return this.started.get() && Clients.allRegisteredResourcesSynced();
    }

    public synchronized void restart() {
        KubernetesCluster cluster = KubernetesClusterConfiguration.get().getCluster();
        this.onConfigChange(cluster, Configuration.getDefaultApiClient());
    }

    public static ResourceSyncManager getSyncManager() {
        return (ResourceSyncManager)ExtensionList.lookup(ResourceSyncManager.class).get(0);
    }
}

