/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync.controller;

import hudson.Extension;
import io.alauda.devops.java.client.apis.DevopsAlaudaIoV1alpha1Api;
import io.alauda.devops.java.client.models.V1alpha1Pipeline;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.devops.java.client.models.V1alpha1PipelineList;
import io.alauda.devops.java.client.utils.DeepCopyUtils;
import io.alauda.jenkins.devops.sync.AlaudaSyncGlobalConfiguration;
import io.alauda.jenkins.devops.sync.client.Clients;
import io.alauda.jenkins.devops.sync.client.JenkinsClient;
import io.alauda.jenkins.devops.sync.client.PipelineClient;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncController;
import io.alauda.jenkins.devops.sync.controller.predicates.BindResourcePredicate;
import io.alauda.jenkins.devops.sync.controller.util.InformerUtils;
import io.alauda.jenkins.devops.sync.util.AlaudaUtils;
import io.alauda.jenkins.devops.sync.util.JenkinsUtils;
import io.alauda.jenkins.devops.sync.util.NamespaceName;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.builder.ControllerBuilder;
import io.kubernetes.client.extended.controller.builder.ControllerManagerBuilder;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.controller.reconciler.Result;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class PipelineController
implements ResourceSyncController {
    private static final Logger logger = LoggerFactory.getLogger(PipelineController.class);
    private static final String CONTROLLER_NAME = "PipelineController";

    @Override
    public void add(ControllerManagerBuilder managerBuilder, SharedInformerFactory factory) {
        DevopsAlaudaIoV1alpha1Api api = new DevopsAlaudaIoV1alpha1Api();
        SharedIndexInformer informer = InformerUtils.getExistingSharedIndexInformer(factory, V1alpha1Pipeline.class);
        if (informer == null) {
            informer = factory.sharedIndexInformerFor(callGeneratorParams -> api.listPipelineForAllNamespacesCall(null, null, null, null, null, null, callGeneratorParams.resourceVersion, callGeneratorParams.timeoutSeconds, callGeneratorParams.watch, null, null), V1alpha1Pipeline.class, V1alpha1PipelineList.class, TimeUnit.MINUTES.toMillis(AlaudaSyncGlobalConfiguration.get().getResyncPeriod()));
        }
        PipelineClient client = new PipelineClient(informer);
        Clients.register(V1alpha1Pipeline.class, client);
        Controller controller = ControllerBuilder.defaultBuilder((SharedInformerFactory)factory).watch(workQueue -> ControllerBuilder.controllerWatchBuilder(V1alpha1Pipeline.class, (WorkQueue)workQueue).withWorkQueueKeyFunc(pipeline -> new Request(pipeline.getMetadata().getNamespace(), pipeline.getMetadata().getName())).withOnAddFilter(pipeline -> {
            logger.debug("[{}] received event: Add, Pipeline '{}/{}'", new Object[]{CONTROLLER_NAME, pipeline.getMetadata().getNamespace(), pipeline.getMetadata().getName()});
            return true;
        }).withOnUpdateFilter((oldPipeline, newPipeline) -> {
            String namespace = oldPipeline.getMetadata().getNamespace();
            String name = oldPipeline.getMetadata().getName();
            if (oldPipeline.getMetadata().getResourceVersion().equals(newPipeline.getMetadata().getResourceVersion())) {
                logger.debug("[{}] resourceVersion of Pipeline '{}/{}' is equal, will skip update event for it", new Object[]{CONTROLLER_NAME, namespace, name});
                return false;
            }
            logger.debug("[{}] received event: Update, Pipeline '{}/{}'", new Object[]{CONTROLLER_NAME, namespace, name});
            return true;
        }).withOnDeleteFilter((pipeline, aBoolean) -> {
            logger.debug("[{}] received event: Delete, Pipeline '{}/{}'", new Object[]{CONTROLLER_NAME, pipeline.getMetadata().getNamespace(), pipeline.getMetadata().getName()});
            return true;
        }).build()).withReconciler((Reconciler)new PipelineReconciler((Lister<V1alpha1Pipeline>)new Lister(informer.getIndexer()))).withName(CONTROLLER_NAME).withReadyFunc(Clients::allRegisteredResourcesSynced).withWorkerCount(4).build();
        managerBuilder.addController(controller);
    }

    static class PipelineReconciler
    implements Reconciler {
        private Lister<V1alpha1Pipeline> lister;
        private JenkinsClient jenkinsClient;

        public PipelineReconciler(Lister<V1alpha1Pipeline> lister) {
            this.lister = lister;
            this.jenkinsClient = JenkinsClient.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result reconcile(Request request) {
            String namespace = request.getNamespace();
            String name = request.getName();
            V1alpha1Pipeline pipeline = (V1alpha1Pipeline)this.lister.namespace(namespace).get(name);
            if (pipeline == null) {
                logger.debug("[{}] Cannot found Pipeline '{}/{}' in local lister, will try to remove it's correspondent Jenkins build", new Object[]{this.getControllerName(), namespace, name});
                try {
                    boolean deleteSucceed = this.jenkinsClient.deletePipeline(new NamespaceName(namespace, name));
                    if (!deleteSucceed) {
                        logger.warn("[{}] Failed to delete build for Pipeline '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
                    }
                }
                catch (Exception e) {
                    logger.warn("[{}] Failed to delete build for Pipeline '{}/{}', reason {}", new Object[]{this.getControllerName(), namespace, name, e.getMessage()});
                }
                return new Result(false);
            }
            if (!BindResourcePredicate.isBindedResource(namespace, pipeline.getSpec().getJenkinsBinding().getName())) {
                logger.debug("[{}] Pipeline '{}/{}' is not bind to correct jenkinsbinding, will skip it", new Object[]{this.getControllerName(), namespace, name});
                return new Result(false);
            }
            V1alpha1PipelineConfig pipelineConfig = (V1alpha1PipelineConfig)Clients.get(V1alpha1PipelineConfig.class).lister().namespace(namespace).get(pipeline.getSpec().getPipelineConfig().getName());
            if (pipelineConfig == null) {
                logger.error("[{}] Unable to find PipelineConfig for Pipeline '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
                return new Result(true);
            }
            String string = pipeline.getMetadata().getUid().intern();
            synchronized (string) {
                PipelineClient pipelineClient = (PipelineClient)Clients.get(V1alpha1Pipeline.class);
                V1alpha1Pipeline pipelineCopy = (V1alpha1Pipeline)DeepCopyUtils.deepCopy((Object)pipeline);
                if (this.isNewPipeline(pipelineCopy)) {
                    boolean succeed;
                    logger.debug("[{}] Pipeline '{}/{} phase is {}, will trigger a new build", new Object[]{this.getControllerName(), namespace, name, pipeline.getStatus().getPhase()});
                    if (this.isCreateByJenkins(pipelineCopy)) {
                        logger.debug("[{}] Pipeline created by Jenkins. It should be triggered, skip create event.", (Object)this.getControllerName());
                        pipelineCopy.getStatus().setPhase("Queued");
                        boolean succeed2 = pipelineClient.update(pipeline, pipelineCopy);
                        return new Result(!succeed2);
                    }
                    if (AlaudaUtils.isCancellable(pipelineCopy.getStatus()) && AlaudaUtils.isCancelled(pipelineCopy.getStatus())) {
                        pipelineCopy.getStatus().setPhase("Cancelled");
                        boolean succeed3 = pipelineClient.update(pipeline, pipelineCopy);
                        return new Result(!succeed3);
                    }
                    WorkflowJob job = this.jenkinsClient.getJob(pipelineCopy, pipelineConfig);
                    if (job == null) {
                        logger.error("[{}] Unable to find Jenkins job for PipelineConfig '{}/{}'", new Object[]{this.getControllerName(), namespace, pipelineConfig.getMetadata().getName()});
                        return new Result(true);
                    }
                    try {
                        succeed = JenkinsUtils.triggerJob(job, pipelineCopy);
                    }
                    catch (IOException e) {
                        logger.info("[{}] Unable to trigger Pipeline '{}/{}', reason: {}", new Object[]{this.getControllerName(), namespace, name, e.getMessage()});
                        return new Result(true);
                    }
                    logger.debug("[{}] Will update Pipeline '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
                    if (succeed) {
                        succeed = pipelineClient.update(pipeline, pipelineCopy);
                        boolean bl = !succeed;
                        return new Result(bl);
                    }
                    pipelineClient.update(pipeline, pipelineCopy);
                    return new Result(true);
                }
                if (AlaudaUtils.isCancellable(pipelineCopy.getStatus()) && AlaudaUtils.isCancelled(pipeline.getStatus())) {
                    logger.debug("[{}] Starting cancel Pipeline '{}/{}'", new Object[]{this.getControllerName(), namespace, name});
                    boolean succeed = this.jenkinsClient.cancelPipeline(new NamespaceName(namespace, name));
                    if (succeed) {
                        pipelineCopy.getStatus().setPhase("Cancelled");
                        succeed = pipelineClient.update(pipeline, pipelineCopy);
                        return new Result(!succeed);
                    }
                    pipelineClient.update(pipeline, pipelineCopy);
                    return new Result(true);
                }
                return new Result(false);
            }
        }

        private String getControllerName() {
            return PipelineController.CONTROLLER_NAME;
        }

        private boolean isNewPipeline(@NotNull V1alpha1Pipeline pipeline) {
            return pipeline.getStatus().getPhase().equals("Pending");
        }

        private boolean isCreateByJenkins(@NotNull V1alpha1Pipeline pipeline) {
            Map labels = pipeline.getMetadata().getLabels();
            return labels != null && "sync.plugin.alauda.io".equals(labels.get("created_by"));
        }
    }
}

