/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.JobProperty;
import hudson.model.JobPropertyDescriptor;
import io.alauda.devops.java.client.models.V1alpha1PipelineConfig;
import io.alauda.jenkins.devops.sync.AlaudaJobProperty;
import io.kubernetes.client.models.V1ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.stapler.DataBoundConstructor;

public class WorkflowJobProperty
extends JobProperty<Job<?, ?>>
implements AlaudaJobProperty {
    private String uid;
    private String namespace;
    private String name;
    private String resourceVersion;
    private String contextAnnotation;

    @DataBoundConstructor
    public WorkflowJobProperty(String namespace, String name, String uid, String resourceVersion, String contextAnnotation) {
        this.namespace = namespace;
        this.name = name;
        this.uid = uid;
        this.resourceVersion = resourceVersion;
        this.contextAnnotation = contextAnnotation;
    }

    public static WorkflowJobProperty getInstance(V1alpha1PipelineConfig pc) {
        V1ObjectMeta meta = pc.getMetadata();
        Map Annotation2 = meta.getAnnotations();
        String contextAnnotation = "{}";
        if (Annotation2 != null) {
            HashMap annotationreuslt = new HashMap();
            for (String key : Annotation2.keySet()) {
                if (!key.startsWith("alauda.io/pipelinecontext.")) continue;
                annotationreuslt.put(key, Annotation2.get(key));
            }
            contextAnnotation = JSONObject.fromObject(annotationreuslt).toString();
        }
        return new WorkflowJobProperty(meta.getNamespace(), meta.getName(), meta.getUid(), meta.getResourceVersion(), contextAnnotation);
    }

    public String getContextAnnotation() {
        return this.contextAnnotation;
    }

    public void setContextAnnotation(String contextAnnotation) {
        this.contextAnnotation = contextAnnotation;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public void setUid(String uid) {
        this.uid = uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public void setResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
    }

    @Extension
    public static final class DescriptorImpl
    extends JobPropertyDescriptor {
        public boolean isApplicable(Class<? extends Job> jobType) {
            return WorkflowJob.class.isAssignableFrom(jobType);
        }

        @Nonnull
        public String getDisplayName() {
            return "Alauda Pipeline job";
        }
    }
}

