/*
 * Decompiled with CFR 0.152.
 */
package io.alauda.jenkins.devops.sync;

import hudson.Extension;
import hudson.util.FormValidation;
import io.alauda.jenkins.devops.sync.controller.ResourceSyncManager;
import javax.annotation.Nonnull;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=100.0)
@Symbol(value={"alaudaSync"})
public class AlaudaSyncGlobalConfiguration
extends GlobalConfiguration {
    private boolean enabled = true;
    private String jenkinsService;
    private int resyncPeriod = 0;
    private transient String errorMsg;
    private String jobNamePattern;
    private String skipOrganizationPrefix;
    private String skipBranchSuffix;

    public AlaudaSyncGlobalConfiguration() {
        this.load();
    }

    public static AlaudaSyncGlobalConfiguration get() {
        return (AlaudaSyncGlobalConfiguration)((Object)GlobalConfiguration.all().get(AlaudaSyncGlobalConfiguration.class));
    }

    @Nonnull
    public String getDisplayName() {
        return "Alauda Jenkins Sync";
    }

    public boolean configure(StaplerRequest req, JSONObject json) {
        String jenkinsServiceBefore = this.jenkinsService;
        boolean enabledBefore = this.enabled;
        req.bindJSON((Object)this, json);
        this.save();
        if (this.jenkinsService != null && this.jenkinsService.equals(jenkinsServiceBefore) && this.enabled == enabledBefore) {
            return true;
        }
        ResourceSyncManager.getSyncManager().restart();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @DataBoundSetter
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getJenkinsService() {
        return this.jenkinsService;
    }

    @DataBoundSetter
    public void setJenkinsService(String jenkinsService) {
        if (jenkinsService != null) {
            jenkinsService = jenkinsService.trim();
        }
        this.jenkinsService = jenkinsService;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    @DataBoundSetter
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public String getJobNamePattern() {
        return this.jobNamePattern;
    }

    @DataBoundSetter
    public void setJobNamePattern(String jobNamePattern) {
        this.jobNamePattern = jobNamePattern;
    }

    public String getSkipOrganizationPrefix() {
        return this.skipOrganizationPrefix;
    }

    @DataBoundSetter
    public void setSkipOrganizationPrefix(String skipOrganizationPrefix) {
        this.skipOrganizationPrefix = skipOrganizationPrefix;
    }

    public String getSkipBranchSuffix() {
        return this.skipBranchSuffix;
    }

    @DataBoundSetter
    public void setSkipBranchSuffix(String skipBranchSuffix) {
        this.skipBranchSuffix = skipBranchSuffix;
    }

    public int getResyncPeriod() {
        return this.resyncPeriod;
    }

    @DataBoundSetter
    public void setResyncPeriod(int resyncPeriod) {
        this.resyncPeriod = resyncPeriod;
    }

    public FormValidation doCheckResyncPeriod(@QueryParameter String value) {
        try {
            int minute = Integer.parseInt(value);
            if (minute < 0) {
                return FormValidation.error((String)"Should be greater than or equal to 0");
            }
            return FormValidation.ok();
        }
        catch (NumberFormatException e) {
            return FormValidation.error((String)"Not a number");
        }
    }
}

