/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.testing;

import com.google.common.base.Throwables;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;

public final class Closeables {
    private Closeables() {
    }

    @Deprecated
    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (IOException | RuntimeException exception) {
                // empty catch block
            }
        }
    }

    public static void closeAll(Closeable ... closeables) throws IOException {
        try {
            Closeables.closeAll((AutoCloseable[])closeables);
        }
        catch (Exception e) {
            Throwables.throwIfInstanceOf((Throwable)e, IOException.class);
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void closeAll(AutoCloseable ... closeables) throws Exception {
        if (closeables == null) {
            return;
        }
        Throwable rootCause = null;
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable e) {
                if (rootCause == null) {
                    rootCause = e;
                    continue;
                }
                if (rootCause == e) continue;
                rootCause.addSuppressed(e);
            }
        }
        if (rootCause != null) {
            Throwables.throwIfUnchecked(rootCause);
            Throwables.throwIfInstanceOf(rootCause, Exception.class);
            throw new RuntimeException(rootCause);
        }
    }

    public static void closeAllRuntimeException(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        RuntimeException rootCause = null;
        for (Closeable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable e) {
                if (rootCause == null) {
                    rootCause = new RuntimeException(e);
                    continue;
                }
                if (rootCause == e) continue;
                rootCause.addSuppressed(e);
            }
        }
        if (rootCause != null) {
            throw rootCause;
        }
    }

    public static <T extends Throwable> T closeAllSuppress(T rootCause, AutoCloseable ... closeables) {
        Objects.requireNonNull(rootCause, "rootCause is null");
        if (closeables == null) {
            return rootCause;
        }
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Throwable e) {
                if (rootCause == e) continue;
                rootCause.addSuppressed(e);
            }
        }
        return rootCause;
    }
}

