/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Preconditions;
import io.airlift.slice.Slice;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public final class Slices {
    public static final Slice EMPTY_SLICE = new Slice();
    private static final int SLICE_ALLOC_THRESHOLD = 524288;
    private static final double SLICE_ALLOW_SKEW = 1.25;

    private Slices() {
    }

    public static Slice ensureSize(Slice existingSlice, int minWritableBytes) {
        if (existingSlice == null) {
            return Slices.allocate(minWritableBytes);
        }
        if (minWritableBytes <= existingSlice.length()) {
            return existingSlice;
        }
        int newCapacity = existingSlice.length() == 0 ? 1 : existingSlice.length();
        int minNewCapacity = existingSlice.length() + minWritableBytes;
        while (newCapacity < minNewCapacity) {
            if (newCapacity < 524288) {
                newCapacity <<= 1;
                continue;
            }
            newCapacity = (int)((double)newCapacity * 1.25);
        }
        Slice newSlice = Slices.allocate(newCapacity);
        newSlice.setBytes(0, existingSlice, 0, existingSlice.length());
        return newSlice;
    }

    public static Slice allocate(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(new byte[capacity]);
    }

    public static Slice allocateDirect(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        return Slices.wrappedBuffer(ByteBuffer.allocateDirect(capacity));
    }

    public static Slice copyOf(Slice slice) {
        return Slices.copyOf(slice, 0, slice.length());
    }

    public static Slice copyOf(Slice slice, int offset, int length) {
        Preconditions.checkPositionIndexes(offset, offset + length, slice.length());
        Slice copy = Slices.allocate(length);
        copy.setBytes(0, slice, offset, length);
        return copy;
    }

    public static Slice wrappedBuffer(ByteBuffer buffer) {
        if (buffer instanceof DirectBuffer) {
            DirectBuffer direct = (DirectBuffer)((Object)buffer);
            return new Slice(null, direct.address(), buffer.capacity(), direct);
        }
        if (buffer.hasArray()) {
            int address = Unsafe.ARRAY_BYTE_BASE_OFFSET + buffer.arrayOffset();
            return new Slice(buffer.array(), address, buffer.capacity(), null);
        }
        throw new IllegalArgumentException("cannot wrap " + buffer.getClass().getName());
    }

    public static Slice wrappedBuffer(byte[] array) {
        if (array.length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array);
    }

    public static Slice wrappedBuffer(byte[] array, int offset, int length) {
        if (length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array, offset, length);
    }

    public static Slice copiedBuffer(String string, Charset charset) {
        Preconditions.checkNotNull(string, "string is null");
        Preconditions.checkNotNull(charset, "charset is null");
        return Slices.wrappedBuffer(string.getBytes(charset));
    }

    public static Slice utf8Slice(String string) {
        return Slices.copiedBuffer(string, StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    public static Slice mapFileReadOnly(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

