/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.FixedLengthSliceInput;
import io.airlift.slice.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;

public final class ChunkedSliceInput
extends FixedLengthSliceInput {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(ChunkedSliceInput.class);
    private final InternalLoader<?> loader;
    private final Slice buffer;
    private final long globalLength;
    private long globalPosition;
    private int bufferPosition;
    private int bufferLength;

    public ChunkedSliceInput(SliceLoader<?> loader, int bufferSize) {
        this.loader = new InternalLoader(Objects.requireNonNull(loader, "loader is null"), bufferSize);
        this.buffer = this.loader.getBufferSlice();
        this.globalLength = loader.getSize();
    }

    @Override
    public long length() {
        return this.globalLength;
    }

    @Override
    public long position() {
        return this.globalPosition + (long)this.bufferPosition;
    }

    @Override
    public void setPosition(long position) {
        if (position < 0L || position > this.globalLength) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " for slice with length " + this.globalLength);
        }
        if (position >= this.globalPosition && position - this.globalPosition < (long)this.bufferLength) {
            this.bufferPosition = (int)(position - this.globalPosition);
            return;
        }
        this.globalPosition = position;
        this.bufferLength = 0;
        this.bufferPosition = 0;
    }

    @Override
    public boolean isReadable() {
        return this.bufferPosition < this.bufferLength;
    }

    @Override
    public int available() {
        return this.bufferLength - this.bufferPosition;
    }

    public void ensureAvailable(int size) {
        if (this.available() >= size) {
            return;
        }
        Preconditions.checkArgument(size <= this.buffer.length(), "Size is larger than buffer");
        ChunkedSliceInput.checkBound(this.position() + (long)size, this.globalLength, "End of stream");
        this.globalPosition += (long)this.bufferPosition;
        this.bufferPosition = 0;
        long readSize = Math.min((long)this.buffer.length(), this.globalLength - this.globalPosition);
        if (readSize > Integer.MAX_VALUE) {
            readSize = Integer.MAX_VALUE;
        }
        this.bufferLength = (int)readSize;
        this.loader.load(this.globalPosition, this.bufferLength);
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public int read() {
        if (this.position() >= this.globalLength) {
            return -1;
        }
        this.ensureAvailable(1);
        int result = this.buffer.getByte(this.bufferPosition) & 0xFF;
        ++this.bufferPosition;
        return result;
    }

    @Override
    public byte readByte() {
        int value = this.read();
        if (value == -1) {
            throw new IndexOutOfBoundsException();
        }
        return (byte)value;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() {
        this.ensureAvailable(2);
        short v = this.buffer.getShort(this.bufferPosition);
        this.bufferPosition += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() {
        this.ensureAvailable(4);
        int v = this.buffer.getInt(this.bufferPosition);
        this.bufferPosition += 4;
        return v;
    }

    @Override
    public long readLong() {
        this.ensureAvailable(8);
        long v = this.buffer.getLong(this.bufferPosition);
        this.bufferPosition += 8;
        return v;
    }

    @Override
    public float readFloat() {
        this.ensureAvailable(4);
        float v = this.buffer.getFloat(this.bufferPosition);
        this.bufferPosition += 4;
        return v;
    }

    @Override
    public double readDouble() {
        this.ensureAvailable(8);
        double v = this.buffer.getDouble(this.bufferPosition);
        this.bufferPosition += 8;
        return v;
    }

    @Override
    public Slice readSlice(int length) {
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        Slice slice = Slices.allocate(length);
        this.readBytes(slice);
        return slice;
    }

    @Override
    public void readBytes(Slice destination, int destinationIndex, int length) {
        ChunkedSliceInput.checkBound(this.position() + (long)length, this.globalLength, "End of stream");
        while (length > 0) {
            int bytesToRead = Math.min(this.available(), length);
            this.buffer.getBytes(this.bufferPosition, destination, destinationIndex, bytesToRead);
            this.bufferPosition += bytesToRead;
            destinationIndex += bytesToRead;
            this.ensureAvailable(Math.min(length -= bytesToRead, this.buffer.length()));
        }
    }

    @Override
    public int read(byte[] destination, int destinationIndex, int length) {
        if (length == 0) {
            return 0;
        }
        if (this.globalLength - this.position() == 0L) {
            return -1;
        }
        length = (int)Math.min((long)length, this.globalLength - this.position());
        this.readBytes(destination, destinationIndex, length);
        return length;
    }

    @Override
    public void readBytes(byte[] destination, int destinationIndex, int length) {
        ChunkedSliceInput.checkBound(this.position() + (long)length, this.globalLength, "End of stream");
        while (length > 0) {
            int bytesToRead = Math.min(this.available(), length);
            this.buffer.getBytes(this.bufferPosition, destination, destinationIndex, bytesToRead);
            this.bufferPosition += bytesToRead;
            destinationIndex += bytesToRead;
            this.ensureAvailable(Math.min(length -= bytesToRead, this.buffer.length()));
        }
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        ChunkedSliceInput.checkBound(this.position() + (long)length, this.globalLength, "End of stream");
        while (length > 0) {
            int bytesToRead = Math.min(this.available(), length);
            this.buffer.getBytes(this.bufferPosition, out, bytesToRead);
            this.bufferPosition += bytesToRead;
            this.ensureAvailable(Math.min(length -= bytesToRead, this.buffer.length()));
        }
    }

    @Override
    public long skip(long length) {
        if ((long)this.available() >= length) {
            this.bufferPosition = (int)((long)this.bufferPosition + length);
            return length;
        }
        this.globalPosition += (long)this.bufferPosition;
        this.bufferPosition = 0;
        this.bufferLength = 0;
        length = Math.min(length, this.remaining());
        this.globalPosition += length;
        return length;
    }

    @Override
    public int skipBytes(int length) {
        return (int)this.skip(length);
    }

    @Override
    public void close() {
        this.globalPosition = this.globalLength;
        this.bufferPosition = 0;
        this.bufferLength = 0;
        this.loader.close();
    }

    @Override
    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + this.loader.getRetainedSize() + this.buffer.getRetainedSize();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SliceStreamInput{");
        builder.append("globalLength=").append(this.globalLength);
        builder.append(", globalPosition=").append(this.globalPosition);
        builder.append(", bufferLength=").append(this.bufferLength);
        builder.append(", bufferPosition=").append(this.bufferPosition);
        builder.append('}');
        return builder.toString();
    }

    private static void checkBound(long index, long size, String message) {
        if (index > size) {
            throw new IndexOutOfBoundsException(message);
        }
    }

    private static class InternalLoader<T extends BufferReference> {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(InternalLoader.class);
        private final SliceLoader<T> loader;
        private final T bufferReference;

        public InternalLoader(SliceLoader<T> loader, int bufferSize) {
            this.loader = loader;
            long minBufferSize = Math.min(loader.getSize(), 128L);
            Preconditions.checkArgument((long)bufferSize >= minBufferSize, "Buffer size must be at least minBufferSize");
            this.bufferReference = loader.createBuffer(bufferSize);
        }

        public Slice getBufferSlice() {
            return this.bufferReference.getSlice();
        }

        public void load(long position, int length) {
            this.loader.load(position, this.bufferReference, length);
        }

        public long getRetainedSize() {
            return INSTANCE_SIZE;
        }

        public void close() {
            this.loader.close();
        }
    }

    public static interface SliceLoader<B extends BufferReference>
    extends Closeable {
        public B createBuffer(int var1);

        public long getSize();

        public void load(long var1, B var3, int var4);

        @Override
        public void close();
    }

    public static interface BufferReference {
        public Slice getSlice();
    }
}

