/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.ToLongFunction;
import org.openjdk.jol.info.ClassLayout;
import sun.misc.Unsafe;

public final class SizeOf {
    public static final byte SIZE_OF_BYTE = 1;
    public static final byte SIZE_OF_SHORT = 2;
    public static final byte SIZE_OF_INT = 4;
    public static final byte SIZE_OF_LONG = 8;
    public static final byte SIZE_OF_FLOAT = 4;
    public static final byte SIZE_OF_DOUBLE = 8;
    public static final int BOOLEAN_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Boolean.class).instanceSize());
    public static final int BYTE_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Byte.class).instanceSize());
    public static final int SHORT_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Short.class).instanceSize());
    public static final int CHARACTER_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Character.class).instanceSize());
    public static final int INTEGER_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Integer.class).instanceSize());
    public static final int LONG_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Long.class).instanceSize());
    public static final int FLOAT_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Float.class).instanceSize());
    public static final int DOUBLE_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Double.class).instanceSize());
    public static final int OPTIONAL_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(Optional.class).instanceSize());
    public static final int OPTIONAL_INT_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(OptionalInt.class).instanceSize());
    public static final int OPTIONAL_LONG_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(OptionalLong.class).instanceSize());
    public static final int OPTIONAL_DOUBLE_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(OptionalDouble.class).instanceSize());
    public static final int STRING_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(String.class).instanceSize());
    private static final int SIMPLE_ENTRY_INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(AbstractMap.SimpleEntry.class).instanceSize());

    public static long sizeOf(boolean[] array) {
        return array == null ? 0L : SizeOf.sizeOfBooleanArray(array.length);
    }

    public static long sizeOf(byte[] array) {
        return array == null ? 0L : SizeOf.sizeOfByteArray(array.length);
    }

    public static long sizeOf(short[] array) {
        return array == null ? 0L : SizeOf.sizeOfShortArray(array.length);
    }

    public static long sizeOf(char[] array) {
        return array == null ? 0L : SizeOf.sizeOfCharArray(array.length);
    }

    public static long sizeOf(int[] array) {
        return array == null ? 0L : SizeOf.sizeOfIntArray(array.length);
    }

    public static long sizeOf(long[] array) {
        return array == null ? 0L : SizeOf.sizeOfLongArray(array.length);
    }

    public static long sizeOf(float[] array) {
        return array == null ? 0L : SizeOf.sizeOfFloatArray(array.length);
    }

    public static long sizeOf(double[] array) {
        return array == null ? 0L : SizeOf.sizeOfDoubleArray(array.length);
    }

    public static long sizeOf(Object[] array) {
        return array == null ? 0L : SizeOf.sizeOfObjectArray(array.length);
    }

    public static long sizeOf(Boolean value) {
        return value == null ? 0L : (long)BOOLEAN_INSTANCE_SIZE;
    }

    public static long sizeOf(Byte value) {
        return value == null ? 0L : (long)BYTE_INSTANCE_SIZE;
    }

    public static long sizeOf(Short value) {
        return value == null ? 0L : (long)SHORT_INSTANCE_SIZE;
    }

    public static long sizeOf(Character value) {
        return value == null ? 0L : (long)CHARACTER_INSTANCE_SIZE;
    }

    public static long sizeOf(Integer value) {
        return value == null ? 0L : (long)INTEGER_INSTANCE_SIZE;
    }

    public static long sizeOf(Long value) {
        return value == null ? 0L : (long)LONG_INSTANCE_SIZE;
    }

    public static long sizeOf(Float value) {
        return value == null ? 0L : (long)FLOAT_INSTANCE_SIZE;
    }

    public static long sizeOf(Double value) {
        return value == null ? 0L : (long)DOUBLE_INSTANCE_SIZE;
    }

    public static <T> long sizeOf(Optional<T> optional, ToLongFunction<T> valueSize) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_INSTANCE_SIZE + valueSize.applyAsLong(optional.get()) : 0L;
    }

    public static <T> long sizeOf(OptionalInt optional) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_INT_INSTANCE_SIZE : 0L;
    }

    public static <T> long sizeOf(OptionalLong optional) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_LONG_INSTANCE_SIZE : 0L;
    }

    public static <T> long sizeOf(OptionalDouble optional) {
        return optional != null && optional.isPresent() ? (long)OPTIONAL_DOUBLE_INSTANCE_SIZE : 0L;
    }

    public static long estimatedSizeOf(String string) {
        return string == null ? 0L : (long)(STRING_INSTANCE_SIZE + string.length() * 2);
    }

    public static <T> long estimatedSizeOf(List<T> list, ToLongFunction<T> valueSize) {
        if (list == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(list.size());
        for (T value : list) {
            result += valueSize.applyAsLong(value);
        }
        return result;
    }

    public static <T> long estimatedSizeOf(Set<T> set, ToLongFunction<T> valueSize) {
        if (set == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(set.size());
        for (T value : set) {
            result += (long)SIMPLE_ENTRY_INSTANCE_SIZE + valueSize.applyAsLong(value);
        }
        return result;
    }

    public static <K, V> long estimatedSizeOf(Map<K, V> map, ToLongFunction<K> keySize, ToLongFunction<V> valueSize) {
        if (map == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            result += (long)SIMPLE_ENTRY_INSTANCE_SIZE + keySize.applyAsLong(entry.getKey()) + valueSize.applyAsLong(entry.getValue());
        }
        return result;
    }

    public static <K, V> long estimatedSizeOf(Map<K, V> map, long keySize, long valueSize) {
        if (map == null) {
            return 0L;
        }
        long result = SizeOf.sizeOfObjectArray(map.size());
        return result += (long)map.size() * ((long)SIMPLE_ENTRY_INSTANCE_SIZE + keySize + valueSize);
    }

    public static long sizeOfBooleanArray(int length) {
        return (long)Unsafe.ARRAY_BOOLEAN_BASE_OFFSET + (long)Unsafe.ARRAY_BOOLEAN_INDEX_SCALE * (long)length;
    }

    public static long sizeOfByteArray(int length) {
        return (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)Unsafe.ARRAY_BYTE_INDEX_SCALE * (long)length;
    }

    public static long sizeOfShortArray(int length) {
        return (long)Unsafe.ARRAY_SHORT_BASE_OFFSET + (long)Unsafe.ARRAY_SHORT_INDEX_SCALE * (long)length;
    }

    public static long sizeOfCharArray(int length) {
        return (long)Unsafe.ARRAY_CHAR_BASE_OFFSET + (long)Unsafe.ARRAY_CHAR_INDEX_SCALE * (long)length;
    }

    public static long sizeOfIntArray(int length) {
        return (long)Unsafe.ARRAY_INT_BASE_OFFSET + (long)Unsafe.ARRAY_INT_INDEX_SCALE * (long)length;
    }

    public static long sizeOfLongArray(int length) {
        return (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)Unsafe.ARRAY_LONG_INDEX_SCALE * (long)length;
    }

    public static long sizeOfFloatArray(int length) {
        return (long)Unsafe.ARRAY_FLOAT_BASE_OFFSET + (long)Unsafe.ARRAY_FLOAT_INDEX_SCALE * (long)length;
    }

    public static long sizeOfDoubleArray(int length) {
        return (long)Unsafe.ARRAY_DOUBLE_BASE_OFFSET + (long)Unsafe.ARRAY_DOUBLE_INDEX_SCALE * (long)length;
    }

    public static long sizeOfObjectArray(int length) {
        return (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE * (long)length;
    }

    private SizeOf() {
    }
}

