/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import org.openjdk.jol.info.ClassLayout;

public final class InputStreamSliceInput
extends SliceInput {
    private static final int INSTANCE_SIZE = Math.toIntExact(ClassLayout.parseClass(InputStreamSliceInput.class).instanceSize());
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int MINIMUM_CHUNK_SIZE = 1024;
    private final InputStream inputStream;
    private final byte[] buffer;
    private final Slice slice;
    private long bufferOffset;
    private int bufferPosition;
    private int bufferFill;

    public InputStreamSliceInput(InputStream inputStream) {
        this(inputStream, 4096);
    }

    public InputStreamSliceInput(InputStream inputStream, int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 1024, "minimum buffer size of 1024 required");
        if (inputStream == null) {
            throw new NullPointerException("inputStream is null");
        }
        this.inputStream = inputStream;
        this.buffer = new byte[bufferSize];
        this.slice = Slices.wrappedBuffer(this.buffer);
    }

    @Override
    public long position() {
        return InputStreamSliceInput.checkedCast(this.bufferOffset + (long)this.bufferPosition);
    }

    @Override
    public void setPosition(long position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        if (this.bufferPosition < this.bufferFill) {
            return this.availableBytes();
        }
        return this.fillBuffer();
    }

    @Override
    public boolean isReadable() {
        return this.available() > 0;
    }

    @Override
    public int skipBytes(int n) {
        return (int)this.skip(n);
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public byte readByte() {
        this.ensureAvailable(1);
        byte v = this.slice.getByteUnchecked(this.bufferPosition);
        ++this.bufferPosition;
        return v;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() {
        this.ensureAvailable(2);
        short v = this.slice.getShortUnchecked(this.bufferPosition);
        this.bufferPosition += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() {
        this.ensureAvailable(4);
        int v = this.slice.getIntUnchecked(this.bufferPosition);
        this.bufferPosition += 4;
        return v;
    }

    @Override
    public long readLong() {
        this.ensureAvailable(8);
        long v = this.slice.getLongUnchecked(this.bufferPosition);
        this.bufferPosition += 8;
        return v;
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int read() {
        if (this.available() == 0) {
            return -1;
        }
        Preconditions.verify(this.availableBytes() > 0);
        int v = this.slice.getByteUnchecked(this.bufferPosition) & 0xFF;
        ++this.bufferPosition;
        return v;
    }

    @Override
    public long skip(long length) {
        int availableBytes = this.availableBytes();
        if ((long)availableBytes >= length) {
            this.bufferPosition = (int)((long)this.bufferPosition + length);
            return length;
        }
        this.bufferPosition = this.bufferFill;
        try {
            long inputStreamSkip = this.inputStream.skip(length - (long)availableBytes);
            this.bufferOffset += inputStreamSkip;
            return (long)availableBytes + inputStreamSkip;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public int read(byte[] destination, int destinationIndex, int length) {
        if (this.available() == 0) {
            return -1;
        }
        Preconditions.verify(this.availableBytes() > 0);
        int batch = Math.min(this.availableBytes(), length);
        this.slice.getBytes(this.bufferPosition, destination, destinationIndex, batch);
        this.bufferPosition += batch;
        return batch;
    }

    @Override
    public void readBytes(byte[] destination, int destinationIndex, int length) {
        while (length > 0) {
            int batch = Math.min(this.availableBytes(), length);
            this.slice.getBytes(this.bufferPosition, destination, destinationIndex, batch);
            this.bufferPosition += batch;
            destinationIndex += batch;
            this.ensureAvailable(Math.min(length -= batch, 1024));
        }
    }

    @Override
    public Slice readSlice(int length) {
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        Slice newSlice = Slices.allocate(length);
        this.readBytes(newSlice, 0, length);
        return newSlice;
    }

    @Override
    public void readBytes(Slice destination, int destinationIndex, int length) {
        while (length > 0) {
            int batch = Math.min(this.availableBytes(), length);
            this.slice.getBytes(this.bufferPosition, destination, destinationIndex, batch);
            this.bufferPosition += batch;
            destinationIndex += batch;
            this.ensureAvailable(Math.min(length -= batch, 1024));
        }
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        while (length > 0) {
            int batch = Math.min(this.availableBytes(), length);
            out.write(this.buffer, this.bufferPosition, batch);
            this.bufferPosition += batch;
            this.ensureAvailable(Math.min(length -= batch, 1024));
        }
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.buffer);
    }

    private int availableBytes() {
        return this.bufferFill - this.bufferPosition;
    }

    private void ensureAvailable(int size) {
        if (this.bufferPosition + size < this.bufferFill) {
            return;
        }
        if (this.fillBuffer() < size) {
            throw new IndexOutOfBoundsException("End of stream");
        }
    }

    private int fillBuffer() {
        int rest = this.bufferFill - this.bufferPosition;
        System.arraycopy(this.buffer, this.bufferPosition, this.buffer, 0, rest);
        this.bufferFill = rest;
        this.bufferOffset += (long)this.bufferPosition;
        this.bufferPosition = 0;
        while (this.bufferFill < 1024) {
            try {
                int bytesRead = this.inputStream.read(this.buffer, this.bufferFill, this.buffer.length - this.bufferFill);
                if (bytesRead < 0) break;
                this.bufferFill += bytesRead;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.bufferFill;
    }

    private static int checkedCast(long value) {
        int result = (int)value;
        Preconditions.checkArgument((long)result == value, "Size is greater than maximum int value");
        return result;
    }
}

