/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.openjdk.jol.info.ClassLayout;

public class OutputStreamSliceOutput
extends SliceOutput {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int MINIMUM_CHUNK_SIZE = 1024;
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(OutputStreamSliceOutput.class).instanceSize();
    private final OutputStream outputStream;
    private final Slice slice;
    private final byte[] buffer;
    private long bufferOffset;
    private int bufferPosition;

    public OutputStreamSliceOutput(OutputStream inputStream) {
        this(inputStream, 4096);
    }

    public OutputStreamSliceOutput(OutputStream outputStream, int bufferSize) {
        Preconditions.checkArgument(bufferSize >= 1024, "minimum buffer size of 1024 required");
        if (outputStream == null) {
            throw new NullPointerException("outputStream is null");
        }
        this.outputStream = outputStream;
        this.buffer = new byte[bufferSize];
        this.slice = Slices.wrappedBuffer(this.buffer);
    }

    @Override
    public void flush() throws IOException {
        this.flushBufferToOutputStream();
        this.outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        try (OutputStream ignored = this.outputStream;){
            this.flushBufferToOutputStream();
        }
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("OutputStream can not be reset");
    }

    @Override
    public void reset(int position) {
        throw new UnsupportedOperationException("OutputStream can not be reset");
    }

    @Override
    public int size() {
        return OutputStreamSliceOutput.checkedCast(this.bufferOffset + (long)this.bufferPosition);
    }

    @Override
    public long getRetainedSize() {
        return this.slice.getRetainedSize() + (long)INSTANCE_SIZE;
    }

    @Override
    public int writableBytes() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void writeByte(int value) {
        this.ensureWritableBytes(1);
        this.slice.setByteUnchecked(this.bufferPosition, value);
        ++this.bufferPosition;
    }

    @Override
    public void writeShort(int value) {
        this.ensureWritableBytes(2);
        this.slice.setShortUnchecked(this.bufferPosition, value);
        this.bufferPosition += 2;
    }

    @Override
    public void writeInt(int value) {
        this.ensureWritableBytes(4);
        this.slice.setIntUnchecked(this.bufferPosition, value);
        this.bufferPosition += 4;
    }

    @Override
    public void writeLong(long value) {
        this.ensureWritableBytes(8);
        this.slice.setLongUnchecked(this.bufferPosition, value);
        this.bufferPosition += 8;
    }

    @Override
    public void writeFloat(float value) {
        this.writeInt(Float.floatToIntBits(value));
    }

    @Override
    public void writeDouble(double value) {
        this.writeLong(Double.doubleToLongBits(value));
    }

    @Override
    public void writeBytes(Slice source) {
        this.writeBytes(source, 0, source.length());
    }

    @Override
    public void writeBytes(Slice source, int sourceIndex, int length) {
        if (length >= 1024) {
            this.flushBufferToOutputStream();
            this.writeToOutputStream(source, sourceIndex, length);
            this.bufferOffset += (long)length;
        } else {
            this.ensureWritableBytes(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, length);
            this.bufferPosition += length;
        }
    }

    @Override
    public void writeBytes(byte[] source) {
        this.writeBytes(source, 0, source.length);
    }

    @Override
    public void writeBytes(byte[] source, int sourceIndex, int length) {
        if (length >= 1024) {
            this.flushBufferToOutputStream();
            this.writeToOutputStream(source, sourceIndex, length);
            this.bufferOffset += (long)length;
        } else {
            this.ensureWritableBytes(length);
            this.slice.setBytes(this.bufferPosition, source, sourceIndex, length);
            this.bufferPosition += length;
        }
    }

    @Override
    public void writeBytes(InputStream in, int length) throws IOException {
        while (length > 0) {
            int batch = this.ensureBatchSize(length);
            this.slice.setBytes(this.bufferPosition, in, batch);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    @Override
    public void writeZero(int length) {
        Preconditions.checkArgument(length >= 0, "length must be 0 or greater than 0.");
        while (length > 0) {
            int batch = this.ensureBatchSize(length);
            Arrays.fill(this.buffer, this.bufferPosition, this.bufferPosition + batch, (byte)0);
            this.bufferPosition += batch;
            length -= batch;
        }
    }

    @Override
    public SliceOutput appendByte(int value) {
        this.writeByte(value);
        return this;
    }

    @Override
    public SliceOutput appendShort(int value) {
        this.writeShort(value);
        return this;
    }

    @Override
    public SliceOutput appendInt(int value) {
        this.writeInt(value);
        return this;
    }

    @Override
    public SliceOutput appendLong(long value) {
        this.writeLong(value);
        return this;
    }

    @Override
    public SliceOutput appendDouble(double value) {
        this.writeDouble(value);
        return this;
    }

    @Override
    public SliceOutput appendBytes(byte[] source, int sourceIndex, int length) {
        this.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public SliceOutput appendBytes(byte[] source) {
        this.writeBytes(source);
        return this;
    }

    @Override
    public SliceOutput appendBytes(Slice slice) {
        this.writeBytes(slice);
        return this;
    }

    @Override
    public Slice slice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getUnderlyingSlice() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString(Charset charset) {
        return this.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OutputStreamSliceOutputAdapter{");
        builder.append("outputStream=").append(this.outputStream);
        builder.append("bufferSize=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }

    private void ensureWritableBytes(int minWritableBytes) {
        if (this.bufferPosition + minWritableBytes > this.slice.length()) {
            this.flushBufferToOutputStream();
        }
    }

    private int ensureBatchSize(int length) {
        this.ensureWritableBytes(Math.min(1024, length));
        return Math.min(length, this.slice.length() - this.bufferPosition);
    }

    private void flushBufferToOutputStream() {
        this.writeToOutputStream(this.buffer, 0, this.bufferPosition);
        this.bufferOffset += (long)this.bufferPosition;
        this.bufferPosition = 0;
    }

    private void writeToOutputStream(byte[] source, int sourceIndex, int length) {
        try {
            this.outputStream.write(source, sourceIndex, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeToOutputStream(Slice source, int sourceIndex, int length) {
        try {
            source.getBytes(sourceIndex, this.outputStream, length);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int checkedCast(long value) {
        int result = (int)value;
        Preconditions.checkArgument((long)result == value, "Size is greater than maximum int value");
        return result;
    }
}

