/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import io.airlift.slice.Slice;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Slices {
    public static final Slice EMPTY_SLICE = new Slice();
    private static final int SLICE_ALLOC_THRESHOLD = 524288;
    private static final double SLICE_ALLOW_SKEW = 1.25;
    private static final ThreadLocal<Map<Charset, CharsetDecoder>> decoders = new ThreadLocal<Map<Charset, CharsetDecoder>>(){

        @Override
        protected Map<Charset, CharsetDecoder> initialValue() {
            return new IdentityHashMap<Charset, CharsetDecoder>();
        }
    };

    public static Slice mapFileReadOnly(File file) throws IOException {
        return Slice.toUnsafeSlice(Files.map((File)file));
    }

    private Slices() {
    }

    public static Slice ensureSize(Slice existingSlice, int minWritableBytes) {
        if (existingSlice == null) {
            return Slices.allocate(minWritableBytes);
        }
        if (minWritableBytes <= existingSlice.length()) {
            return existingSlice;
        }
        int newCapacity = existingSlice.length() == 0 ? 1 : existingSlice.length();
        int minNewCapacity = existingSlice.length() + minWritableBytes;
        while (newCapacity < minNewCapacity) {
            if (newCapacity < 524288) {
                newCapacity <<= 1;
                continue;
            }
            newCapacity = (int)((double)newCapacity * 1.25);
        }
        Slice newSlice = Slices.allocate(newCapacity);
        newSlice.setBytes(0, existingSlice, 0, existingSlice.length());
        return newSlice;
    }

    public static Slice allocate(int capacity) {
        if (capacity == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(new byte[capacity]);
    }

    public static Slice wrappedBuffer(byte[] array) {
        if (array.length == 0) {
            return EMPTY_SLICE;
        }
        return new Slice(array);
    }

    public static Slice copiedBuffer(String string, Charset charset) {
        Preconditions.checkNotNull((Object)string, (Object)"string is null");
        Preconditions.checkNotNull((Object)charset, (Object)"charset is null");
        return Slices.wrappedBuffer(string.getBytes(charset));
    }

    public static Slice utf8Slice(String string) {
        return Slices.copiedBuffer(string, StandardCharsets.UTF_8);
    }

    public static String decodeString(ByteBuffer src, Charset charset) {
        CharsetDecoder decoder = Slices.getDecoder(charset);
        CharBuffer dst = CharBuffer.allocate((int)((double)src.remaining() * (double)decoder.maxCharsPerByte()));
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
        return dst.flip().toString();
    }

    private static CharsetDecoder getDecoder(Charset charset) {
        Preconditions.checkNotNull((Object)charset, (Object)"charset is null");
        Map<Charset, CharsetDecoder> map = decoders.get();
        CharsetDecoder d = map.get(charset);
        if (d != null) {
            d.reset();
            d.onMalformedInput(CodingErrorAction.REPLACE);
            d.onUnmappableCharacter(CodingErrorAction.REPLACE);
            return d;
        }
        d = charset.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPLACE);
        d.onUnmappableCharacter(CodingErrorAction.REPLACE);
        map.put(charset, d);
        return d;
    }
}

