/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import io.airlift.slice.JvmUtils;
import io.airlift.slice.Preconditions;
import io.airlift.slice.Slice;

public class XxHash64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;
    private static final long DEFAULT_SEED = 0L;

    public static long hash(long value) {
        long hash = 2870177450012600269L;
        hash = XxHash64.updateTail(hash, value);
        hash = XxHash64.finalShuffle(hash);
        return hash;
    }

    public static long hash(Slice data) {
        return XxHash64.hash(data, 0, data.length());
    }

    public static long hash(long seed, Slice data) {
        return XxHash64.hash(seed, data, 0, data.length());
    }

    public static long hash(Slice data, int offset, int length) {
        return XxHash64.hash(0L, data, offset, length);
    }

    public static long hash(long seed, Slice data, int offset, int length) {
        long hash;
        Preconditions.checkPositionIndexes(0, offset + length, data.length());
        Object base = data.getBase();
        long index = data.getAddress() + (long)offset;
        long end = index + (long)length;
        if (length >= 32) {
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed + 0L;
            long v4 = seed - -7046029288634856825L;
            long limit = end - 32L;
            do {
                v1 = XxHash64.mix(v1, JvmUtils.unsafe.getLong(base, index));
                v2 = XxHash64.mix(v2, JvmUtils.unsafe.getLong(base, index += 8L));
                v3 = XxHash64.mix(v3, JvmUtils.unsafe.getLong(base, index += 8L));
                v4 = XxHash64.mix(v4, JvmUtils.unsafe.getLong(base, index += 8L));
            } while ((index += 8L) <= limit);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            hash = XxHash64.update(hash, v1);
            hash = XxHash64.update(hash, v2);
            hash = XxHash64.update(hash, v3);
            hash = XxHash64.update(hash, v4);
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += (long)length;
        while (index <= end - 8L) {
            hash = XxHash64.updateTail(hash, JvmUtils.unsafe.getLong(base, index));
            index += 8L;
        }
        if (index <= end - 4L) {
            hash = XxHash64.updateTail(hash, JvmUtils.unsafe.getInt(base, index));
            index += 4L;
        }
        while (index < end) {
            hash = XxHash64.updateTail(hash, JvmUtils.unsafe.getByte(base, index));
            ++index;
        }
        hash = XxHash64.finalShuffle(hash);
        return hash;
    }

    private static long mix(long current, long value) {
        return Long.rotateLeft(current + value * -4417276706812531889L, 31) * -7046029288634856825L;
    }

    private static long update(long hash, long value) {
        long temp = hash ^ XxHash64.mix(0L, value);
        return temp * -7046029288634856825L + -8796714831421723037L;
    }

    private static long updateTail(long hash, long value) {
        long temp = hash ^ XxHash64.mix(0L, value);
        return Long.rotateLeft(temp, 27) * -7046029288634856825L + -8796714831421723037L;
    }

    private static long updateTail(long hash, int value) {
        long unsigned = (long)value & 0xFFFFFFFFL;
        long temp = hash ^ unsigned * -7046029288634856825L;
        return Long.rotateLeft(temp, 23) * -4417276706812531889L + 1609587929392839161L;
    }

    private static long updateTail(long hash, byte value) {
        int unsigned = value & 0xFF;
        long temp = hash ^ (long)unsigned * 2870177450012600261L;
        return Long.rotateLeft(temp, 11) * -7046029288634856825L;
    }

    private static long finalShuffle(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }
}

