/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.junit;

import io.airlift.junit.ReportMissingTestAnnotation;
import java.util.Set;
import java.util.stream.Collectors;

class MissingAnnotationsException
extends Exception {
    private final Class<?> testClass;
    private final Set<ReportMissingTestAnnotation.Failure> failures;

    public MissingAnnotationsException(Class<?> testClass, Set<ReportMissingTestAnnotation.Failure> failures) {
        this.testClass = testClass;
        this.failures = failures;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Set<ReportMissingTestAnnotation.Failure> getFailures() {
        return this.failures;
    }

    @Override
    public String toString() {
        return "Failed to instantiate " + this.testClass.getName() + " due to missing @Test annotation on the following methods:\n" + this.failures.stream().map(failure -> "    '" + failure.child() + "', which overrides '" + failure.parent() + "'").collect(Collectors.joining("\n"));
    }
}

