/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.zstd;

import io.airlift.compress.v2.MalformedInputException;
import io.airlift.compress.v2.zstd.UnsafeUtil;
import io.airlift.compress.v2.zstd.ZstdDecompressor;
import io.airlift.compress.v2.zstd.ZstdFrameDecompressor;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;
import java.util.Objects;
import sun.misc.Unsafe;

public class ZstdJavaDecompressor
implements ZstdDecompressor {
    private final ZstdFrameDecompressor decompressor = new ZstdFrameDecompressor();

    @Override
    public int decompress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) throws MalformedInputException {
        ZstdJavaDecompressor.verifyRange(input, inputOffset, inputLength);
        ZstdJavaDecompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return this.decompressor.decompress(input, inputAddress, inputLimit, output, outputAddress, outputLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decompress(MemorySegment input, MemorySegment output) throws MalformedInputException {
        try {
            byte[] inputBase = UnsafeUtil.getBase(input);
            long inputAddress = UnsafeUtil.getAddress(input);
            long inputLimit = Math.addExact(inputAddress, input.byteSize());
            byte[] outputBase = UnsafeUtil.getBase(output);
            long outputAddress = UnsafeUtil.getAddress(output);
            long outputLimit = Math.addExact(outputAddress, output.byteSize());
            int n = this.decompressor.decompress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit);
            return n;
        }
        finally {
            Reference.reachabilityFence(input);
            Reference.reachabilityFence(output);
        }
    }

    @Override
    public long getDecompressedSize(byte[] input, int offset, int length) {
        int baseAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + offset;
        return ZstdFrameDecompressor.getDecompressedSize(input, baseAddress, baseAddress + length);
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

