/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.snappy;

import io.airlift.compress.v2.MalformedInputException;
import io.airlift.compress.v2.internal.NativeLoader;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.util.Optional;

final class SnappyNative {
    private final MemorySegment lengthBuffer = MemorySegment.ofArray(new long[1]);
    private static final int SNAPPY_OK = 0;
    private static final int SNAPPY_INVALID_INPUT = 1;
    private static final int SNAPPY_BUFFER_TOO_SMALL = 2;
    private static final Optional<LinkageError> LINKAGE_ERROR;
    private static final MethodHandle COMPRESS_METHOD;
    private static final MethodHandle DECOMPRESS_METHOD;
    private static final MethodHandle MAX_COMPRESSED_LENGTH_METHOD;
    private static final MethodHandle UNCOMPRESSED_LENGTH_METHOD;

    SnappyNative() {
    }

    public static long maxCompressedLength(long inputLength) {
        return SnappyNative.maxCompressedLengthInternal(inputLength);
    }

    public long compress(MemorySegment input, long inputLength, MemorySegment compressed, long compressedLength) {
        this.lengthBuffer.set(ValueLayout.JAVA_LONG, 0L, compressedLength);
        SnappyNative.compressInternal(input, inputLength, compressed, this.lengthBuffer);
        return this.lengthBuffer.get(ValueLayout.JAVA_LONG, 0L);
    }

    public long decompress(MemorySegment compressed, long compressedLength, MemorySegment uncompressed, long uncompressedLength) {
        this.lengthBuffer.set(ValueLayout.JAVA_LONG, 0L, uncompressedLength);
        SnappyNative.decompressInternal(compressed, compressedLength, uncompressed, this.lengthBuffer);
        return this.lengthBuffer.get(ValueLayout.JAVA_LONG, 0L);
    }

    public long decompressedLength(MemorySegment compressed, long compressedLength) {
        this.lengthBuffer.set(ValueLayout.JAVA_LONG, 0L, 0L);
        SnappyNative.decompressedLengthInternal(compressed, compressedLength, this.lengthBuffer);
        return this.lengthBuffer.get(ValueLayout.JAVA_LONG, 0L);
    }

    public static boolean isEnabled() {
        return LINKAGE_ERROR.isEmpty();
    }

    public static void verifyEnabled() {
        if (LINKAGE_ERROR.isPresent()) {
            throw new IllegalStateException("Snappy native library is not enabled", LINKAGE_ERROR.get());
        }
    }

    private static void compressInternal(MemorySegment input, long inputLength, MemorySegment compressed, MemorySegment compressedLength) {
        int result;
        try {
            result = COMPRESS_METHOD.invokeExact(input, inputLength, compressed, compressedLength);
        }
        catch (Throwable t) {
            throw new AssertionError("should not reach here", t);
        }
        switch (result) {
            case 0: {
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Output buffer too small");
            }
            default: {
                throw new IllegalArgumentException("Unknown error occurred during compression: result=" + result);
            }
        }
    }

    private static void decompressInternal(MemorySegment compressed, long compressedLength, MemorySegment output, MemorySegment outputLength) {
        int result;
        try {
            result = DECOMPRESS_METHOD.invokeExact(compressed, compressedLength, output, outputLength);
        }
        catch (Throwable t) {
            throw new AssertionError("should not reach here", t);
        }
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                throw new MalformedInputException(0L, "Invalid input");
            }
            case 2: {
                throw new IllegalArgumentException("Output buffer too small");
            }
            default: {
                throw new IllegalArgumentException("Unknown error occurred during decompression: result=" + result);
            }
        }
    }

    private static long maxCompressedLengthInternal(long inputLength) {
        try {
            return MAX_COMPRESSED_LENGTH_METHOD.invokeExact(inputLength);
        }
        catch (Throwable t) {
            throw new AssertionError("should not reach here", t);
        }
    }

    private static void decompressedLengthInternal(MemorySegment compressed, long compressedLength, MemorySegment decompressedLength) {
        int result;
        try {
            result = UNCOMPRESSED_LENGTH_METHOD.invokeExact(compressed, compressedLength, decompressedLength);
        }
        catch (Throwable t) {
            throw new AssertionError("should not reach here", t);
        }
        switch (result) {
            case 0: {
                break;
            }
            case 1: {
                throw new MalformedInputException(0L, "Invalid input");
            }
            default: {
                throw new IllegalArgumentException("Unknown error occurred during decompressed length calculation: result=" + result);
            }
        }
    }

    static {
        NativeLoader.Symbols<MethodHandles> symbols = NativeLoader.loadSymbols("snappy", MethodHandles.class, java.lang.invoke.MethodHandles.lookup());
        LINKAGE_ERROR = symbols.linkageError();
        MethodHandles methodHandles = symbols.symbols();
        COMPRESS_METHOD = methodHandles.compress();
        DECOMPRESS_METHOD = methodHandles.uncompress();
        MAX_COMPRESSED_LENGTH_METHOD = methodHandles.maxCompressedLength();
        UNCOMPRESSED_LENGTH_METHOD = methodHandles.uncompressedLength();
    }

    private record MethodHandles(MethodHandle compress, MethodHandle uncompress, MethodHandle maxCompressedLength, MethodHandle uncompressedLength) {
    }
}

