/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.snappy;

import io.airlift.compress.v2.snappy.SnappyCompressor;
import io.airlift.compress.v2.snappy.SnappyRawCompressor;
import io.airlift.compress.v2.snappy.UnsafeUtil;
import java.lang.foreign.MemorySegment;
import java.lang.ref.Reference;
import java.util.Objects;
import sun.misc.Unsafe;

public final class SnappyJavaCompressor
implements SnappyCompressor {
    private final short[] table = new short[16384];

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return SnappyRawCompressor.maxCompressedLength(uncompressedSize);
    }

    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        SnappyJavaCompressor.verifyRange(input, inputOffset, inputLength);
        SnappyJavaCompressor.verifyRange(output, outputOffset, maxOutputLength);
        long inputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + inputOffset;
        long inputLimit = inputAddress + (long)inputLength;
        long outputAddress = Unsafe.ARRAY_BYTE_BASE_OFFSET + outputOffset;
        long outputLimit = outputAddress + (long)maxOutputLength;
        return SnappyRawCompressor.compress(input, inputAddress, inputLimit, output, outputAddress, outputLimit, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        try {
            byte[] inputBase = UnsafeUtil.getBase(input);
            long inputAddress = UnsafeUtil.getAddress(input);
            long inputLimit = Math.addExact(inputAddress, input.byteSize());
            byte[] outputBase = UnsafeUtil.getBase(output);
            long outputAddress = UnsafeUtil.getAddress(output);
            long outputLimit = Math.addExact(outputAddress, output.byteSize());
            int n = SnappyRawCompressor.compress(inputBase, inputAddress, inputLimit, outputBase, outputAddress, outputLimit, this.table);
            return n;
        }
        finally {
            Reference.reachabilityFence(input);
            Reference.reachabilityFence(output);
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException(String.format("Invalid offset or length (%s, %s) in array of length %s", offset, length, data.length));
        }
    }
}

