/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.lzo;

import io.airlift.compress.v2.hadoop.HadoopInputStream;
import io.airlift.compress.v2.hadoop.HadoopOutputStream;
import io.airlift.compress.v2.hadoop.HadoopStreams;
import io.airlift.compress.v2.lzo.LzoHadoopInputStream;
import io.airlift.compress.v2.lzo.LzoHadoopOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class LzoHadoopStreams
implements HadoopStreams {
    private static final List<String> HADOOP_CODEC_NAMES = List.of("org.apache.hadoop.io.compress.LzoCodec", "com.hadoop.compression.lzo.LzoCodec");
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private final int bufferSize;

    public LzoHadoopStreams() {
        this(262144);
    }

    public LzoHadoopStreams(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".lzo_deflate";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return HADOOP_CODEC_NAMES;
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) {
        return new LzoHadoopInputStream(in, this.bufferSize);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) {
        return new LzoHadoopOutputStream(out, this.bufferSize);
    }
}

