/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.deflate;

import io.airlift.compress.v2.deflate.JdkDeflateHadoopInputStream;
import io.airlift.compress.v2.deflate.JdkDeflateHadoopOutputStream;
import io.airlift.compress.v2.hadoop.HadoopInputStream;
import io.airlift.compress.v2.hadoop.HadoopOutputStream;
import io.airlift.compress.v2.hadoop.HadoopStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public class JdkDeflateHadoopStreams
implements HadoopStreams {
    private static final int BUFFER_SIZE = 8192;

    @Override
    public String getDefaultFileExtension() {
        return ".deflate";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.DefaultCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) throws IOException {
        return new JdkDeflateHadoopInputStream(in, 8192);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) throws IOException {
        return new JdkDeflateHadoopOutputStream(out, 8192);
    }
}

