/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.v2.deflate;

import io.airlift.compress.v2.Compressor;
import java.lang.foreign.MemorySegment;
import java.util.Objects;
import java.util.zip.Deflater;

public class DeflateCompressor
implements Compressor {
    private static final int EXTRA_COMPRESSION_SPACE = 16;
    private static final int COMPRESSION_LEVEL = 4;
    private final int compressionLevel;

    public DeflateCompressor() {
        this(4);
    }

    public DeflateCompressor(int compressionLevel) {
        if (compressionLevel < 0 || compressionLevel > 9) {
            throw new IllegalArgumentException("Invalid compression level: %d (must be 0-9)".formatted(compressionLevel));
        }
        this.compressionLevel = compressionLevel;
    }

    @Override
    public int maxCompressedLength(int uncompressedSize) {
        return uncompressedSize + (uncompressedSize + 7 >> 3) + (uncompressedSize + 63 >> 6) + 5 + 16;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        DeflateCompressor.verifyRange(input, inputOffset, inputLength);
        DeflateCompressor.verifyRange(output, outputOffset, maxOutputLength);
        Deflater deflater = new Deflater(this.compressionLevel, true);
        try {
            deflater.setInput(input, inputOffset, inputLength);
            deflater.finish();
            int compressedDataLength = deflater.deflate(output, outputOffset, maxOutputLength, 3);
            if (!deflater.finished()) {
                throw new IllegalStateException("Output buffer too small");
            }
            int n = compressedDataLength;
            return n;
        }
        finally {
            deflater.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int compress(MemorySegment input, MemorySegment output) {
        int maxCompressedLength = this.maxCompressedLength(Math.toIntExact(input.byteSize()));
        if (output.byteSize() < (long)maxCompressedLength) {
            throw new IllegalArgumentException("Output buffer must be at least " + maxCompressedLength + " bytes");
        }
        Deflater deflater = new Deflater(this.compressionLevel, true);
        try {
            deflater.setInput(input.asByteBuffer());
            deflater.finish();
            int compressedDataLength = deflater.deflate(output.asByteBuffer(), 3);
            if (!deflater.finished()) {
                throw new IllegalStateException("maxCompressedLength formula is incorrect, because deflate produced more data");
            }
            int n = compressedDataLength;
            return n;
        }
        finally {
            deflater.end();
        }
    }

    private static void verifyRange(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data is null");
        if (offset < 0 || length < 0 || offset + length > data.length) {
            throw new IllegalArgumentException("Invalid offset or length (%s, %s) in array of length %s".formatted(offset, length, data.length));
        }
    }
}

