/*
 * Decompiled with CFR 0.152.
 */
package airbrake;

import airbrake.AirbrakeNotice;
import airbrake.Backtrace;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class AirbrakeNoticeBuilder {
    private String apiKey;
    private String projectRoot;
    private String environmentName;
    private String errorMessage;
    private Backtrace backtrace = new Backtrace(Arrays.asList("backtrace is empty"));
    private final Map<String, Object> environment = new TreeMap<String, Object>();
    private Map<String, Object> request = new TreeMap<String, Object>();
    private Map<String, Object> session = new TreeMap<String, Object>();
    private final List<String> environmentFilters = new LinkedList<String>();
    private Backtrace backtraceBuilder = new Backtrace();
    private String errorClass;
    private boolean hasRequest = false;
    private String url;
    private String component;

    public AirbrakeNoticeBuilder(String apiKey, Backtrace backtraceBuilder, Throwable throwable, String env) {
        this(apiKey, throwable.getMessage(), env);
        this.backtraceBuilder = backtraceBuilder;
        this.errorClass(throwable);
        this.backtrace(throwable);
    }

    public AirbrakeNoticeBuilder(String apiKey, String errorMessage) {
        this(apiKey, errorMessage, "test");
    }

    public AirbrakeNoticeBuilder(String apiKey, String errorMessage, String env) {
        this.apiKey(apiKey);
        this.errorMessage(errorMessage);
        this.env(env);
    }

    public AirbrakeNoticeBuilder(String apiKey, Throwable throwable) {
        this(apiKey, new Backtrace(), throwable, "test");
    }

    public AirbrakeNoticeBuilder(String apiKey, Throwable throwable, String env) {
        this(apiKey, new Backtrace(), throwable, env);
    }

    public AirbrakeNoticeBuilder(String apiKey, Throwable throwable, String projectRoot, String env) {
        this(apiKey, new Backtrace(), throwable, env);
        this.projectRoot(projectRoot);
    }

    protected void addSessionKey(String key, Object value) {
        this.session.put(key, value);
    }

    private void apiKey(String apiKey) {
        if (this.notDefined(apiKey)) {
            this.error("The API key for the project this error is from (required). Get this from the project's page in airbrake.");
        }
        this.apiKey = apiKey;
    }

    protected void backtrace(Backtrace backtrace) {
        this.backtrace = backtrace;
    }

    private void backtrace(Throwable throwable) {
        this.backtrace(this.backtraceBuilder.newBacktrace(throwable));
    }

    protected void ec2EnvironmentFilters() {
        this.environmentFilter("AWS_SECRET");
        this.environmentFilter("EC2_PRIVATE_KEY");
        this.environmentFilter("AWS_ACCESS");
        this.environmentFilter("EC2_CERT");
    }

    private void env(String env) {
        this.environmentName = env;
    }

    protected void environment(Map<String, Object> environment) {
        this.environment.putAll(environment);
    }

    protected void environment(Properties properties) {
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            this.environment.put(property.getKey().toString(), property.getValue());
        }
    }

    public void environmentFilter(String filter) {
        this.environmentFilters.add(filter);
    }

    private void error(String message) {
        throw new RuntimeException(message);
    }

    private void errorClass(Throwable throwable) {
        this.errorClass = throwable.getClass().getName();
        if (this.errorMessage == null || this.errorMessage.trim().isEmpty()) {
            this.errorMessage = '[' + throwable.getClass().toString() + ']';
        }
    }

    protected boolean errorClassIs(String possibleErrorClass) {
        return this.errorClass.equals(possibleErrorClass);
    }

    private void errorMessage(String errorMessage) {
        this.errorMessage = this.notDefined(errorMessage) ? "" : errorMessage;
    }

    protected void filteredSystemProperties() {
        this.environment(System.getProperties());
        this.standardEnvironmentFilters();
        this.ec2EnvironmentFilters();
    }

    public AirbrakeNotice newNotice() {
        return new AirbrakeNotice(this.apiKey, this.projectRoot, this.environmentName, this.errorMessage, this.errorClass, this.backtrace, this.request, this.session, this.environment, this.environmentFilters, this.hasRequest, this.url, this.component);
    }

    private boolean notDefined(Object object) {
        return object == null;
    }

    protected void projectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    protected void request(Map<String, Object> request) {
        this.request = request;
    }

    protected void session(Map<String, Object> session) {
        this.session.putAll(session);
    }

    protected void setRequest(String url, String component) {
        this.hasRequest = true;
        this.url = url;
        this.component = component;
    }

    protected void standardEnvironmentFilters() {
        this.environmentFilter("java.awt.*");
        this.environmentFilter("java.vendor.*");
        this.environmentFilter("java.class.path");
        this.environmentFilter("java.vm.specification.*");
    }
}

