/*
 * Decompiled with CFR 0.152.
 */
package airbrake;

import airbrake.Backtrace;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AirbrakeNotice {
    private final String apiKey;
    private final String errorMessage;
    private Backtrace backtrace = new Backtrace(Arrays.asList("backtrace is empty"));
    private String projectRoot;
    private String environmentName;
    private final Map<String, Object> environment = new TreeMap<String, Object>();
    private Map<String, Object> request = new TreeMap<String, Object>();
    private Map<String, Object> session = new TreeMap<String, Object>();
    private String errorClass;
    private boolean hasRequest = false;
    private final String url;
    private final String component;

    public AirbrakeNotice(String apiKey, String projectRoot, String environmentName, String errorMessage, String errorClass, Backtrace backtrace, Map<String, Object> request, Map<String, Object> session, Map<String, Object> environment, List<String> environmentFilters, boolean hasRequest, String url, String component) {
        this.apiKey = apiKey;
        this.projectRoot = projectRoot;
        this.environmentName = environmentName;
        this.errorClass = errorClass;
        this.errorMessage = errorMessage;
        this.backtrace = backtrace;
        this.request = request;
        this.session = session;
        this.hasRequest = hasRequest;
        this.url = url;
        this.component = component;
        this.filter(environment, environmentFilters);
    }

    public String apiKey() {
        return this.apiKey;
    }

    public Backtrace backtrace() {
        return this.backtrace;
    }

    public String component() {
        return this.component;
    }

    public String env() {
        return this.environmentName;
    }

    public Map<String, Object> environment() {
        return this.environment;
    }

    public String errorClass() {
        return this.errorClass;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    private void filter(Map<String, Object> environment, List<String> environmentFilters) {
        for (String key : environment.keySet()) {
            if (this.matches(environmentFilters, key)) continue;
            this.environment.put(key, environment.get(key));
        }
    }

    public boolean hasRequest() {
        return this.hasRequest;
    }

    private boolean matches(List<String> environmentFilters, String key) {
        for (String filter : environmentFilters) {
            if (!key.matches(filter)) continue;
            return true;
        }
        return false;
    }

    public String projectRoot() {
        return this.projectRoot;
    }

    public Map<String, Object> request() {
        return this.request;
    }

    public Map<String, Object> session() {
        return this.session;
    }

    public String url() {
        return this.url;
    }
}

