/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.springframework.boot.metrics;

import io.agroal.springframework.boot.AgroalDataSource;
import io.agroal.springframework.boot.metrics.AgroalDataSourcePoolMetadata;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.jdbc.DataSourceUnwrapper;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={AgroalDataSource.class})
public class AgroalPoolDataSourceMetadataProviderConfiguration {
    @Bean
    public DataSourcePoolMetadataProvider agroalPoolDataSourceMetadataProvider() {
        return dataSource -> {
            AgroalDataSource agroalDataSource = (AgroalDataSource)DataSourceUnwrapper.unwrap((DataSource)dataSource, AgroalDataSource.class);
            if (agroalDataSource != null) {
                return new AgroalDataSourcePoolMetadata(agroalDataSource);
            }
            return null;
        };
    }
}

