/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.jni;

import io.agora.common.AgoraServiceJNI;
import io.agora.rtm.RtmServiceContext;
import io.agora.rtm.jni.AgoraRtmServiceJNI;
import io.agora.rtm.jni.IChannel;
import io.agora.rtm.jni.IChannelAttributeOptions;
import io.agora.rtm.jni.IChannelEventHandler;
import io.agora.rtm.jni.IMessage;
import io.agora.rtm.jni.IRtmAttribute;
import io.agora.rtm.jni.IRtmCallEventHandler;
import io.agora.rtm.jni.IRtmCallManager;
import io.agora.rtm.jni.IRtmChannelAttribute;
import io.agora.rtm.jni.IRtmServiceEventHandler;
import io.agora.rtm.jni.ISendMessageOptions;
import io.agora.rtm.jni.PEER_SUBSCRIPTION_OPTION;
import io.agora.rtm.jni.SWIGTYPE_p_long_long;

public class IRtmService {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public IRtmService(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IRtmService obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                throw new UnsupportedOperationException("C++ destructor does not have public access");
            }
            this.swigCPtr = 0L;
        }
    }

    public int initialize(String appId, IRtmServiceEventHandler eventHandler) {
        return AgoraRtmServiceJNI.IRtmService_initialize(this.swigCPtr, this, appId, IRtmServiceEventHandler.getCPtr(eventHandler), eventHandler);
    }

    public void addEventHandler(IRtmServiceEventHandler eventHandler) {
        AgoraRtmServiceJNI.IRtmService_addEventHandler(this.swigCPtr, this, IRtmServiceEventHandler.getCPtr(eventHandler), eventHandler);
    }

    public void removeEventHandler(IRtmServiceEventHandler eventHandler) {
        AgoraRtmServiceJNI.IRtmService_removeEventHandler(this.swigCPtr, this, IRtmServiceEventHandler.getCPtr(eventHandler), eventHandler);
    }

    public void release(boolean sync) {
        AgoraRtmServiceJNI.IRtmService_release__SWIG_0(this.swigCPtr, this, sync);
    }

    public void release() {
        AgoraRtmServiceJNI.IRtmService_release__SWIG_1(this.swigCPtr, this);
    }

    public int login(String token, String userId) {
        return AgoraRtmServiceJNI.IRtmService_login(this.swigCPtr, this, token, userId);
    }

    public int logout() {
        return AgoraRtmServiceJNI.IRtmService_logout(this.swigCPtr, this);
    }

    public int renewToken(String token) {
        return AgoraRtmServiceJNI.IRtmService_renewToken(this.swigCPtr, this, token);
    }

    public int sendMessageToPeer(String peerId, IMessage message) {
        return AgoraRtmServiceJNI.IRtmService_sendMessageToPeer__SWIG_0(this.swigCPtr, this, peerId, IMessage.getCPtr(message), message);
    }

    public int sendMessageToPeer(String peerId, IMessage message, ISendMessageOptions options) {
        return AgoraRtmServiceJNI.IRtmService_sendMessageToPeer__SWIG_1(this.swigCPtr, this, peerId, IMessage.getCPtr(message), message, ISendMessageOptions.getCPtr(options), options);
    }

    public IChannel createChannel(String channelId, IChannelEventHandler eventHandler) {
        long cPtr = AgoraRtmServiceJNI.IRtmService_createChannel(this.swigCPtr, this, channelId, IChannelEventHandler.getCPtr(eventHandler), eventHandler);
        return cPtr == 0L ? null : new IChannel(cPtr, true);
    }

    public IRtmCallManager getRtmCallManager(IRtmCallEventHandler eventHandler) {
        long cPtr = AgoraRtmServiceJNI.IRtmService_getRtmCallManager(this.swigCPtr, this, IRtmCallEventHandler.getCPtr(eventHandler), eventHandler);
        return cPtr == 0L ? null : new IRtmCallManager(cPtr, true);
    }

    public IMessage createMessage() {
        long cPtr = AgoraRtmServiceJNI.IRtmService_createMessage__SWIG_0(this.swigCPtr, this);
        return cPtr == 0L ? null : new IMessage(cPtr, false);
    }

    public IMessage createMessage(String message) {
        long cPtr = AgoraRtmServiceJNI.IRtmService_createMessage__SWIG_1(this.swigCPtr, this, message);
        return cPtr == 0L ? null : new IMessage(cPtr, false);
    }

    public IMessage createMessage(byte[] rawData, int length) {
        long cPtr = AgoraRtmServiceJNI.IRtmService_createMessage__SWIG_2(this.swigCPtr, this, rawData, length);
        return cPtr == 0L ? null : new IMessage(cPtr, false);
    }

    public IMessage createMessage(byte[] rawData, int length, String description) {
        long cPtr = AgoraRtmServiceJNI.IRtmService_createMessage__SWIG_3(this.swigCPtr, this, rawData, length, description);
        return cPtr == 0L ? null : new IMessage(cPtr, false);
    }

    public int setParameters(String parameters) {
        return AgoraRtmServiceJNI.IRtmService_setParameters(this.swigCPtr, this, parameters);
    }

    public int queryPeersOnlineStatus(String[] peerIds, int peerCount, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_queryPeersOnlineStatus(this.swigCPtr, this, peerIds, peerCount, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int subscribePeersOnlineStatus(String[] peerIds, int peerCount, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_subscribePeersOnlineStatus(this.swigCPtr, this, peerIds, peerCount, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int unsubscribePeersOnlineStatus(String[] peerIds, int peerCount, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_unsubscribePeersOnlineStatus(this.swigCPtr, this, peerIds, peerCount, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int queryPeersBySubscriptionOption(PEER_SUBSCRIPTION_OPTION option, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_queryPeersBySubscriptionOption(this.swigCPtr, this, option.swigValue(), SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int setLocalUserAttributes(IRtmAttribute[] attributes, SWIGTYPE_p_long_long requestId) {
        int size = attributes.length;
        long base = AgoraServiceJNI.newPointerArray(size);
        for (int index = 0; index < size; ++index) {
            IRtmAttribute attribute = attributes[index];
            AgoraServiceJNI.setPointerArrayElement(base, index, IRtmAttribute.getCPtr(attribute));
        }
        int ret = AgoraRtmServiceJNI.IRtmService_setLocalUserAttributes(this.swigCPtr, this, base, size, SWIGTYPE_p_long_long.getCPtr(requestId));
        AgoraServiceJNI.deletePointerArray(base);
        return ret;
    }

    public int addOrUpdateLocalUserAttributes(IRtmAttribute[] attributes, SWIGTYPE_p_long_long requestId) {
        int size = attributes.length;
        long base = AgoraServiceJNI.newPointerArray(size);
        for (int index = 0; index < size; ++index) {
            IRtmAttribute attribute = attributes[index];
            AgoraServiceJNI.setPointerArrayElement(base, index, IRtmAttribute.getCPtr(attribute));
        }
        int ret = AgoraRtmServiceJNI.IRtmService_addOrUpdateLocalUserAttributes(this.swigCPtr, this, base, size, SWIGTYPE_p_long_long.getCPtr(requestId));
        AgoraServiceJNI.deletePointerArray(base);
        return ret;
    }

    public int deleteLocalUserAttributesByKeys(String[] attributeKeys, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_deleteLocalUserAttributesByKeys(this.swigCPtr, this, attributeKeys, attributeKeys.length, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int clearLocalUserAttributes(SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_clearLocalUserAttributes(this.swigCPtr, this, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int getUserAttributes(String userId, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_getUserAttributes(this.swigCPtr, this, userId, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int getUserAttributesByKeys(String userId, String[] attributeKeys, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_getUserAttributesByKeys(this.swigCPtr, this, userId, attributeKeys, attributeKeys.length, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int setChannelAttributes(String channelId, IRtmChannelAttribute[] attributes, IChannelAttributeOptions option, SWIGTYPE_p_long_long requestId) {
        int size = attributes.length;
        long base = AgoraServiceJNI.newPointerArray(size);
        for (int index = 0; index < size; ++index) {
            IRtmChannelAttribute attribute = attributes[index];
            AgoraServiceJNI.setPointerArrayElement(base, index, IRtmChannelAttribute.getCPtr(attribute));
        }
        int ret = AgoraRtmServiceJNI.IRtmService_setChannelAttributes(this.swigCPtr, this, channelId, base, size, IChannelAttributeOptions.getCPtr(option), SWIGTYPE_p_long_long.getCPtr(requestId));
        AgoraServiceJNI.deletePointerArray(base);
        return ret;
    }

    public int addOrUpdateChannelAttributes(String channelId, IRtmChannelAttribute[] attributes, IChannelAttributeOptions option, SWIGTYPE_p_long_long requestId) {
        int size = attributes.length;
        long base = AgoraServiceJNI.newPointerArray(size);
        for (int index = 0; index < size; ++index) {
            IRtmChannelAttribute attribute = attributes[index];
            AgoraServiceJNI.setPointerArrayElement(base, index, IRtmChannelAttribute.getCPtr(attribute));
        }
        int ret = AgoraRtmServiceJNI.IRtmService_addOrUpdateChannelAttributes(this.swigCPtr, this, channelId, base, size, IChannelAttributeOptions.getCPtr(option), SWIGTYPE_p_long_long.getCPtr(requestId));
        AgoraServiceJNI.deletePointerArray(base);
        return ret;
    }

    public int deleteChannelAttributesByKeys(String channelId, String[] attributeKeys, IChannelAttributeOptions option, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_deleteChannelAttributesByKeys(this.swigCPtr, this, channelId, attributeKeys, attributeKeys.length, IChannelAttributeOptions.getCPtr(option), SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int clearChannelAttributes(String channelId, IChannelAttributeOptions option, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_clearChannelAttributes(this.swigCPtr, this, channelId, IChannelAttributeOptions.getCPtr(option), SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int getChannelAttributes(String channelId, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_getChannelAttributes(this.swigCPtr, this, channelId, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int getChannelAttributesByKeys(String channelId, String[] attributeKeys, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_getChannelAttributesByKeys(this.swigCPtr, this, channelId, attributeKeys, attributeKeys.length, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int getChannelMemberCount(String[] channelIds, SWIGTYPE_p_long_long requestId) {
        return AgoraRtmServiceJNI.IRtmService_getChannelMemberCount(this.swigCPtr, this, channelIds, channelIds.length, SWIGTYPE_p_long_long.getCPtr(requestId));
    }

    public int setLogFile(String filePath) {
        return AgoraRtmServiceJNI.IRtmService_setLogFile(this.swigCPtr, this, filePath);
    }

    public int setLogFilter(int filter) {
        return AgoraRtmServiceJNI.IRtmService_setLogFilter(this.swigCPtr, this, filter);
    }

    public int setLogFileSize(int fileSizeInKBytes) {
        return AgoraRtmServiceJNI.IRtmService_setLogFileSize(this.swigCPtr, this, fileSizeInKBytes);
    }

    public static int setRtmServiceContext(RtmServiceContext context) {
        io.agora.rtm.jni.RtmServiceContext ctx = new io.agora.rtm.jni.RtmServiceContext();
        ctx.setAreaCode(context.areaCode);
        return AgoraRtmServiceJNI.setRtmServiceContext(io.agora.rtm.jni.RtmServiceContext.getCPtr(ctx), ctx);
    }

    public String GetSessionId() {
        return AgoraRtmServiceJNI.IRtmService_GetSessionId(this.swigCPtr, this);
    }
}

