/*
 * Decompiled with CFR 0.152.
 */
package io.agora.rtm.internal;

import android.content.Context;
import io.agora.common.annotation.NonNull;
import io.agora.rtm.RtmClient;
import io.agora.rtm.RtmClientListener;
import io.agora.rtm.RtmServiceContext;
import io.agora.rtm.internal.AgoraSysUtils;
import io.agora.rtm.internal.CommonUtility;
import io.agora.rtm.internal.RtmClientImpl;
import io.agora.rtm.internal.RtmSdkContext;
import io.agora.rtm.jni.IRtmService;

public class RtmManager {
    private static final String RTM_SDK_LIBRARY_NAME = "agora-rtm-sdk-jni";
    private static CommonUtility rtm_android_monitor = null;

    public static void initializeNative() {
        RtmSdkContext.setLibraryName(RTM_SDK_LIBRARY_NAME);
    }

    public static RtmClient createRtmInstance(final @NonNull Context context, @NonNull String appId, @NonNull RtmClientListener eventListener) throws Exception {
        if (rtm_android_monitor == null) {
            rtm_android_monitor = new CommonUtility(context);
        }
        return new RtmClientImpl(new RtmSdkContext(){

            @Override
            public String getConfigDir() {
                return AgoraSysUtils.getAppStorageDir(context);
            }

            @Override
            public String getDataDir() {
                return AgoraSysUtils.getCacheDir(context);
            }

            @Override
            public String getPluginDir() {
                return AgoraSysUtils.getNativeLibraryDir(context);
            }

            @Override
            public String getDeviceId() {
                return AgoraSysUtils.getDeviceId();
            }

            @Override
            public String getDeviceInfo() {
                return AgoraSysUtils.getDeviceInfo();
            }

            @Override
            public String getSystemInfo() {
                return AgoraSysUtils.getSystemInfo();
            }
        }, appId, eventListener);
    }

    public static int setRtmServiceContext(RtmServiceContext context) {
        return IRtmService.setRtmServiceContext(context);
    }

    public static String getRtmSessionId(@NonNull RtmClient client) {
        if (client == null) {
            return "";
        }
        return ((RtmClientImpl)client).GetSessionId();
    }
}

